% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_center_to.R
\name{step_center_to}
\alias{step_center_to}
\alias{tidy.step_center_to}
\title{Centering numeric data to a value besides their mean}
\usage{
step_center_to(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  centers = NULL,
  center_fn = mean,
  na_rm = TRUE,
  skip = FALSE,
  id = rand_id("center_to")
)

\method{tidy}{step_center_to}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose which variables are
affected by the step. See [selections()] for more details. For the `tidy`
method, these are not currently used.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the quantities for preprocessing have
been estimated.}

\item{centers}{A named numeric vector of centers. This is `NULL` until
computed by [prep.recipe()] (or it can be specified as a named
numeric vector as well?).}

\item{center_fn}{a function to be used to calculate where the center should be}

\item{na_rm}{A logical value indicating whether `NA` values should be removed
during computations.}

\item{skip}{A logical. Should the step be skipped when the recipe is baked by
[bake.recipe()]? While all operations are baked when [prep.recipe()] is
run, some operations may not be able to be conducted on new data (e.g.
processing the outcome variable(s)). Care should be taken when using `skip
= TRUE` as it may affect the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A `step_center_to` object.}
}
\value{
An updated version of `recipe` with the new step added to the
  sequence of existing steps (if any). For the `tidy` method, a tibble with
  columns `terms` (the selectors or variables selected) and `value` (the
  centers).
}
\description{
`step_center_to` generalizes `step_center` to allow for a different function
than the `mean` function to calculate centers. It creates a *specification*
of a recipe step that will normalize numeric data to have a 'center' of zero.
}
\details{
Centering data means that the average of a variable is subtracted
  from the data. `step_center_to` estimates the variable centers from the
  data used in the `training` argument of `prep.recipe`. `bake.recipe` then
  applies the centering to new data sets using these centers.
}
\examples{
data(biomass, package = "modeldata")

biomass_tr <- biomass[biomass$dataset == "Training",]
biomass_te <- biomass[biomass$dataset == "Testing",]

rec <- recipes::recipe(
 HHV ~ carbon + hydrogen + oxygen + nitrogen + sulfur,
 data = biomass_tr)

center_trans <- rec \%>\%
  step_center_to(carbon, contains("gen"), -hydrogen)

center_obj <- recipes::prep(center_trans, training = biomass_tr)

transformed_te <- recipes::bake(center_obj, biomass_te)

biomass_te[1:10, names(transformed_te)]
transformed_te

recipes::tidy(center_trans)
recipes::tidy(center_obj)
}
\seealso{
[recipe()] [prep.recipe()] [bake.recipe()]
}
\concept{normalization_methods}
\concept{preprocessing}
\keyword{datagen}
