% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-generics.R, R/s3-sparsebnFit.R
\docType{class}
\name{sparsebnFit}
\alias{as.sparsebnFit}
\alias{is.sparsebnFit}
\alias{print.sparsebnFit}
\alias{sparsebnFit}
\title{sparsebnFit class}
\usage{
sparsebnFit(x)

as.sparsebnFit(x)

is.sparsebnFit(x)

\method{print}{sparsebnFit}(x, ...)
}
\arguments{
\item{x}{Only used internally.}

\item{...}{(optional) additional arguments.}
}
\description{
Main class for representing DAG estimates: Represents a single DAG estimate in the solution path.
Generally speaking, these estimates should be wrapped up in a \code{\link{sparsebnPath}} object, but
can be handled separately if desired (be careful!).
}
\section{Slots}{

\describe{
\item{\code{edges}}{(edgeList) Edge list of estimated DAG (see \code{\link{edgeList}}).}
\item{\code{lambda}}{(numeric) Value of lambda for this estimate.}
\item{\code{nedge}}{(integer) Number of edges in this estimate.}
\item{\code{pp}}{(integer) Number of nodes.}
\item{\code{nn}}{(integer) Number of observations this estimate was based on.}
\item{\code{time}}{(numeric) Time in seconds to generate this estimate.}
}
}

\section{Methods}{

\code{\link{get.adjacency.matrix}}
\code{\link{num.nodes}}, \code{\link{num.edges}}, \code{\link{num.samples}}
}

