% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsebnUtils-generate.R
\name{random.dag}
\alias{random.dag}
\title{Generate random DAGs}
\usage{
random.dag(nnode, nedge, FUN = NULL, permute = TRUE)
}
\arguments{
\item{nnode}{Number of nodes in the DAG.}

\item{nedge}{Number of edges in the DAG.}

\item{FUN}{Optional function to be used as a random number generator.}

\item{permute}{If \code{TRUE}, order of nodes will be randomly permuted.
If \code{FALSE}, output will be ordered according to its
topological sort, i.e. with a lower-triangular adjacency matrix.}
}
\value{
An (weighted) adjacency matrix.
}
\description{
Generate a random DAG with fixed number of edges.
}
\details{
FUN can be any function whose first argument is called \code{n}. This
allows for both random and deterministic outputs.
}
