% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_sparta.R
\name{mult}
\alias{mult}
\alias{mult.sparta}
\alias{mult.numeric}
\alias{div}
\alias{div.sparta}
\alias{div.numeric}
\title{Multiplication and division of sparse tables}
\usage{
mult(x, y)

\method{mult}{sparta}(x, y)

\method{mult}{numeric}(x, y)

div(x, y)

\method{div}{sparta}(x, y)

\method{div}{numeric}(x, y)
}
\arguments{
\item{x}{sparta object or scalar}

\item{y}{sparta object or scalar}
}
\value{
A sparta object or a scalar
}
\description{
Multiplication and division of sparse tables
}
\examples{

# ----------
# Example 1)
# ----------

x <- array(
  c(1,0,0,2,3,4,0,0),
  dim = c(2,2,2),
  dimnames = list(
    a = c("a1", "a2"),
    b = c("b1", "b2"),
    c = c("c1", "c2")
  )
)

y <- array(
  c(1,3,0,2,4,2,7,0,
    1,8,0,1,6,2,1,0,
    1,5,0,3,2,9,1,0),
  dim = c(2,2,2, 3),
  dimnames = list(
    b = c("b1", "b2"),
    d = c("d1", "d2"),
    a = c("a1", "a2"),
    e = c("e1", "e2", "e3")
  )
)

sx <- as_sparta(x)
sy <- as_sparta(y)

sparsity(sx)
table_size(sx)
dim_names(sx)
names(sx)

mult(sx, sy)
div(sy, sx)

# ----------
# Example 2)
# ----------

d1   <- mtcars[, c("cyl", "vs", "am")]
d1[] <- lapply(d1, as.character)
d2   <- mtcars[, c("am", "gear", "carb")]
d2[] <- lapply(d2, as.character)
ds1  <- as_sparta(d1)
ds2  <- as_sparta(d2)

mult(ds1, ds2)

# ----------
# Example 3)
# ----------

su <- sparta_unity_struct(dim_names(sy), rank = 3.1415)
sparta_rank(su)
sum(su)
sun <- normalize(su)
sun
sum(sun)

mult(sx, sun)

# ----------
# Example 4)
# ----------
so <- sparta_ones(dim_names(sx))
mult(so, 2)
}
