% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emulation_utilities.R
\name{generate_emulator_model}
\alias{generate_emulator_model}
\title{Internal function used to generate the requested emulator, and graph
training performance}
\usage{
generate_emulator_model(technique, parameters, measures, dataset,
  algorithm_settings, timepoint = NULL, normalised = FALSE)
}
\arguments{
\item{technique}{Machine learning technique being employed}

\item{parameters}{Parameters on which the model will take as input}

\item{measures}{Simulation responses the model should predict}

\item{dataset}{The training dataset used to create the model}

\item{algorithm_settings}{Algorithm settings object, of parameters used by
the emulation creation algorithm}

\item{timepoint}{Simulation timepoint for which an emulator is being created}

\item{normalised}{Whether the data being input as training data has been
normalised. Affects whether predictions generated by the emulator are
rescaled or not}
}
\value{
Emulator objects of the specified technique for all measures, and
performance statistics
}
\description{
Internal function used to generate the requested emulator, and graph
training performance
}
\keyword{internal}
