% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trend.line.R
\name{trend.line}
\alias{trend.line}
\title{trend.line}
\usage{
trend.line(x, y, type = "linear", plot = TRUE, ...)
}
\arguments{
\item{x}{Vector of x}

\item{y}{Vector of y}

\item{type}{Trend line types are: 'linear', 'exponential', 'logarithmic', 'polynomial'}

\item{plot}{plot results (TRUE/FALSE)}

\item{...}{Additional arguments passed to plot}
}
\value{
A list class object with the following components:
for type = 'linear'  x is slope and y is intercept
for type = 'exponential', 'logarithmic', or 'polynomial'
  x is original x variable and y is vector of fit regression line
}
\description{
Calculated specified trend line of x,y
}
\examples{
x <- 1:10
y <- jitter(x^2)
  opar <- par
  par(mfcol=c(2,2))
    trend.line(x,y,type='linear',plot=TRUE,pch=20,main='Linear')
    trend.line(x,y,type='exponential',plot=TRUE,pch=20,main='Exponential')
    trend.line(x,y,type='logarithmic',plot=TRUE,pch=20,main='Logarithmic')
    trend.line(x,y,type='polynomial',plot=TRUE,pch=20,main='Polynomial')
 par <- opar

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}

