% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster.modified.ttest.R
\name{raster.modified.ttest}
\alias{raster.modified.ttest}
\title{Dutilleul moving window bivariate raster correlation}
\usage{
raster.modified.ttest(
  x,
  y,
  x.idx = 1,
  y.idx = 1,
  d = "AUTO",
  sub.sample = FALSE,
  type = "hexagon",
  p = 0.1,
  size = NULL
)
}
\arguments{
\item{x}{x raster for correlation, SpatialPixelsDataFrame or SpatialGridDataFrame object}

\item{y}{y raster for correlation, SpatialPixelsDataFrame or SpatialGridDataFrame object}

\item{x.idx}{Index for the column in the x raster object}

\item{y.idx}{Index for the column in the y raster object}

\item{d}{Distance for finding neighbors}

\item{sub.sample}{Should a sub-sampling approach be employed (TRUE/FALSE)}

\item{type}{If sub.sample = TRUE, what type of sample (random  or hexagon)}

\item{p}{If sub.sample = TRUE, what proportion of population should be sampled}

\item{size}{Fixed sample size}
}
\value{
A SpatialPixelsDataFrame or SpatialPointsDataFrame with the following attributes:
\itemize{ 
\item   corr        Correlation 
\item   Fstat       The F-statistic calculated as [degrees of freedom * unscaled F-statistic]
\item   p.value     p-value for the test
\item   moran.x     Moran's-I for x 
\item   moran.y     Moran's-I for y  
 }
}
\description{
A bivarate raster correlation using Dutilleul's modified t-test
}
\note{
This function provides a bivariate moving window correlation using the modified t-test to account for 
        spatial autocorrelation. Point based subsampling is provided for computation tractability.  
        The hexagon sampling is recommended as it it good at capturing spatial process that includes 
        nonstationarity and anistropy.
}
\examples{
\dontrun{
library(gstat)                                         
library(sp)                                            
                                                        
data(meuse)                                            
data(meuse.grid)                                       
coordinates(meuse) <- ~x + y                           
coordinates(meuse.grid) <- ~x + y                      
                                                        
# GRID-1 log(copper):                                              
v1 <- variogram(log(copper) ~ 1, meuse)                  
x1 <- fit.variogram(v1, vgm(1, "Sph", 800, 1))           
G1 <- krige(zinc ~ 1, meuse, meuse.grid, x1, nmax = 30)
gridded(G1) <- TRUE                                      
G1@data = as.data.frame(G1@data[,-2])

# GRID-2 log(elev):                                              
v2 <- variogram(log(elev) ~ 1, meuse)                  
x2 <- fit.variogram(v2, vgm(.1, "Sph", 1000, .6))        
G2 <- krige(elev ~ 1, meuse, meuse.grid, x2, nmax = 30)
gridded(G2) <- TRUE    
G2@data <- as.data.frame(G2@data[,-2])
G2@data[,1] <- G2@data[,1]

corr <- raster.modifed.ttest(G1, G2)
  plot(raster::raster(corr,1))
  
corr.rand <- raster.modifed.ttest(G1, G2, sub.sample = TRUE, type = "random")	 
corr.hex <- raster.modifed.ttest(G1, G2, sub.sample = TRUE, d = 500, size = 1000)	
  head(corr.hex@data)
    bubble(corr.hex, "corr") 
}

}
\references{
Clifford, P., S. Richardson, D. Hemon (1989), Assessing the significance of the correlation between two 
  spatial processes. Biometrics 45:123-134.
Dutilleul, P. (1993), Modifying the t test for assessing the correlation between two spatial processes. 
  Biometrics 49:305-314.
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
