% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poly.regression.R
\name{poly.regression}
\alias{poly.regression}
\title{Local Polynomial Regression}
\usage{
poly.regression(
  y,
  x = NULL,
  s = 0.75,
  impute = FALSE,
  na.only = FALSE,
  ci = FALSE,
  ...
)
}
\arguments{
\item{y}{Vector to smooth or impute NA values}

\item{x}{Optional x covariate data (must match dimensions of y)}

\item{s}{Smoothing parameter (larger equates to more smoothing)}

\item{impute}{(FALSE/TRUE) Should NA values be inputed}

\item{na.only}{(FALSE/TRUE) Should only NA values be change in y}

\item{ci}{(FALSE/TRUE) Should confidence intervals be returned}

\item{...}{Additional arguments passed to loess}
}
\value{
If ci = FALSE, a vector of smoothed values,
otherwise a list object with:
\itemize{
\item loess - A vector, same length of y, representing the smoothed or
inputed data
\item lower.ci - Lower confidence interval
\item upper.ci - Upper confidence interval
}
}
\description{
Calculates a Local Polynomial Regression for smoothing
or imputation of missing data.

This is a wrapper function for loess that simplifies data smoothing and imputation of
missing values. The function allows for smoothing a vector, based on an index
(derived automatically) or covariates. If the impute option is TRUE NA values are imputed,
otherwise the returned vector will still have NA's present. If impute and na.only are both
TRUE the vector is returned, without being smoothed but with imputed NA values filled in.
The loess weight function is defined using the tri-cube weight function w(x) = (1-|x|^3)^3
where; x is the distance of a data point from the point on the curve being fitted.
}
\examples{
 x <- seq(-20, 20, 0.1)
 y <- sin(x)/x + rnorm(length(x), sd=0.03)
 p <- which(y == "NaN")
 y <- y[-p]
 r <- poly.regression(y, ci=TRUE, s=0.30)
 
 plot(y,type="l", lwd=0.5, main="s = 0.10")
   y.polygon <- c((r$lower.ci)[1:length(y)], (r$upper.ci)[rev(1:length(y))])
   x.polygon <- c(1:length(y), rev(1:length(y)))
   polygon(x.polygon, y.polygon, col="#00009933", border=NA) 
      lines(r$loess, lwd=1.5, col="red")
 
 # Impute NA values, replacing only NA's
 y.na <- y
 y.na[c(100,200,300)] <- NA 
 p.y <- poly.regression(y.na, s=0.10, impute = TRUE, na.only = TRUE)
 y - p.y
 
 plot(p.y,type="l", lwd=1.5, col="blue", main="s = 0.10")
   lines(y, lwd=1.5, col="red")

}
\seealso{
\code{\link[stats]{loess}} for loess ... model options
}
\author{
Jeffrey S. Evans  \href{mailto:jeffrey_evans@tnc.org}{jeffrey_evans@tnc.org}
}
