% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rasterCorrelation.R
\name{rasterCorrelation}
\alias{rasterCorrelation}
\title{Raster correlation}
\usage{
rasterCorrelation(x, y, s = 3, type = "pearson")
}
\arguments{
\item{x}{A terra SpatRaster class object for x}

\item{y}{A terra SpatRasterclass object for y}

\item{s}{Scale of window. Can be a single value, two 
values for uneven window or a custom matrix. 
Must be odd number (eg., s=3, for 3x3 window or 
s=c(3,5) for 3 x 5 window)}

\item{type}{Type of output, options are: "pearson", "spearman", 
"covariance"}
}
\value{
A terra SpatRaster class object
}
\description{
Performs a moving window correlation between 
             two rasters
}
\note{
The NA behavior is set to na.rm = TRUE to make default outputs
      consistent between the terra and raster packages.
}
\examples{
\donttest{
library(terra)
 
r <- rast(system.file("ex/logo.tif", package="terra"))  
  x <- r[[1]]
  y <- r[[3]]
  
 r.cor <- rasterCorrelation(x, y, s = 5, type = "spearman")
   plot(r.cor)
}

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
