% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster.invert.R
\name{raster.invert}
\alias{raster.invert}
\title{Invert raster}
\usage{
raster.invert(x)
}
\arguments{
\item{x}{raster object}
}
\value{
raster class object with inverted (flipped) raster values
}
\description{
Inverts (flip) the values of a raster
}
\note{
Inverts raster values using the formula: (((x - max(x)) * -1) + min(x)
}
\examples{
library(terra)
r <- rast(nrows=500, ncols=500, xmin=571823, xmax=616763, 
            ymin=4423540, ymax=4453690)
 crs(r) <- "epsg:9001"
r[] <- runif(ncell(r), 1000, 2500)
r <- focal(r, focalMat(r, 150, "Gauss") )

r.inv <- raster.invert(r)

opar <- par(no.readonly=TRUE)
    par(mfrow=c(1,2))
      plot(r, main="original raster")
      plot(r.inv, main="inverted raster") 
par(opar)   

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
