% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erase.points.R
\name{erase.point}
\alias{erase.point}
\title{Erase points}
\usage{
erase.point(y, x, inside = TRUE)
}
\arguments{
\item{y}{A sf POINT object}

\item{x}{A sf POLYGON object}

\item{inside}{(TRUE/FALSE) Remove points inside polygon, else outside polygon}
}
\value{
An sf POINT object
}
\description{
Removes points intersecting a polygon feature class
}
\details{
Used to erase points that intersect polygon(s). The default of inside=TRUE
erases points inside the polygons however, if inside=FALSE then
the function results in an intersection where points that
intersect the polygon are retained.
}
\examples{

library(sf)
  
if (require(sp, quietly = TRUE)) {
  data(meuse, package = "sp")
  meuse <- st_as_sf(meuse, coords = c("x", "y"), crs = 28992, agr = "constant")

  s <- st_as_sf(st_sample(st_as_sfc(st_bbox(meuse)), size=1000, 
                 type = "regular"))
    s$id <- 1:nrow(s)
  b <- st_buffer(s[sample(1:nrow(s),5),], dist=300)
    b$id <- 1:nrow(b)
  
# Erase points based on polygons
in.erase <- erase.point(s, b)
out.erase <- erase.point(s, b, inside = FALSE)

 opar <- par(no.readonly=TRUE)
 par(mfrow=c(2,2))
   plot(st_geometry(s), pch=20, main="original data")
     plot(st_geometry(b),add=TRUE)
   plot(st_geometry(in.erase), pch=20, main="erased data")
     plot(st_geometry(b),add=TRUE)
   plot(st_geometry(out.erase), pch=20,  
        main="erased data using inside=FALSE")
     plot(st_geometry(b),add=TRUE)
 par(opar)

} else { 
  cat("Please install sp package to run example", "\n")
}

}
\author{
Jeffrey S. Evans    <jeffrey_evans<at>tnc.org>
}
