% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_response_curves.R
\name{get_response_curves}
\alias{get_response_curves}
\title{Gets data to allow custom plotting of response curves}
\usage{
get_response_curves(
  model = NULL,
  variables = NULL,
  quantiles = c(0.1, 0.5, 0.9),
  grid.resolution = 200,
  verbose = TRUE
)
}
\arguments{
\item{model}{A model fitted with \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}.}

\item{variables}{Character vector, names of predictors to plot. If \code{NULL}, the most important variables (importance higher than the median) in \code{model} are selected. Default: \code{NULL}.}

\item{quantiles}{Numeric vector with values between 0 and 1, argument \code{probs} of \link[stats]{quantile}. Quantiles to set the other variables to. Default: \code{c(0.1, 0.5, 0.9)}}

\item{grid.resolution}{Integer between 20 and 500. Resolution of the plotted curve Default: \code{100}}

\item{verbose}{Logical, if TRUE the plot is printed. Default: \code{TRUE}}
}
\value{
A data frame with the following columns:
\itemize{
\item \code{response}: Predicted values of the response, obtained with \code{stats::predict()}.
\item \code{predictor}: Values of the given predictor.
\item \code{quantile}: Grouping column, values of the quantiles at which the other predictors are set to generate the response curve.
\item \code{model}: Model number, only relevant if the model was produced with \code{\link[=rf_repeat]{rf_repeat()}}.
\item \code{predictor.name}: Grouping variable, name of the predictor.
\item \code{response.name}: Grouping variable, name of the response variable.
}
}
\description{
Generates and returns the data required to plot the response curves of a model fitted with \code{\link[=rf]{rf()}}, \code{\link[=rf_repeat]{rf_repeat()}}, or \code{\link[=rf_spatial]{rf_spatial()}}.
}
\details{
All variables that are not plotted in a particular response curve are set to the values of their respective quantiles, and the response curve for each one of these quantiles is shown in the plot.
}
\examples{
if(interactive()){

#loading example data
data(plant_richness_df)

#fitting random forest model
out <- rf(
 data = plant_richness_df,
 dependent.variable.name = "richness_species_vascular",
 predictor.variable.names = colnames(plant_richness_df)[5:21],
 n.cores = 1,
 verbose = FALSE
)

#getting data frame with response curves
p <- get_response_curves(out)
head(p)

}
}
\seealso{
\code{\link[=plot_response_curves]{plot_response_curves()}}
}
