% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knmi_historic.R
\name{knmi_historic_data}
\alias{knmi_historic_data}
\title{Retrieve historic weather data for the Netherlands}
\format{
The returned data frame contains the following columns:
\itemize{
  \item station = ID of measurement station;
  \item date = Date;
  \item FH	= Hourly mean wind speed (in 0.1 m/s)
  \item FX	= Maximum wind gust (in 0.1 m/s) during the hourly division;
  \item T = Temperature (in 0.1 degrees Celsius) at 1.50 m at the time of observation;
  \item DR	= Precipitation duration (in 0.1 hour) during the hourly division;
  \item RH	= Hourly precipitation amount (in 0.1 mm) (-1 for <0.05 mm);
  \item city = City where the measurement station is located;
  \item lon = Longitude of station (crs = 4326);
  \item lat = Latitude of station (crs = 4326).
}
}
\usage{
knmi_historic_data(startyear, endyear)
}
\arguments{
\item{startyear}{start year for historic weather data.}

\item{endyear}{end year for historic weather data.}
}
\value{
Data frame containing weather data and meta data for weather station locations.
}
\description{
This function retrieves historic weather data collected by the official KNMI weather stations. See spatialrisk::knmi_stations for a list of the official KNMI weather stations.
}
\examples{
\dontrun{
knmi_historic_data(2015, 2019)
}

}
\author{
Martin Haringa
}
