% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haversine.R
\name{haversine}
\alias{haversine}
\title{Haversine great circle distance}
\usage{
haversine(lat_from, lon_from, lat_to, lon_to, r = 6378137)
}
\arguments{
\item{lat_from}{Latitude of point.}

\item{lon_from}{Longitude of point.}

\item{lat_to}{Latitude of point.}

\item{lon_to}{Longitude of point.}

\item{r}{Radius of the earth; default = 6378137m}
}
\value{
Vector of distances in the same unit as \code{r} (default in meters).
}
\description{
The shortest distance between two points (i.e., the
'great-circle-distance' or 'as the crow flies'), according to the 'haversine
method'. This method assumes a spherical earth, ignoring ellipsoidal effects.
Note that this version is implemented in C++. A quick benchmark to the
version of geosphere showed it to be a non-insignificant speed enhancement.
The algorithm converges in one-twentieth of the original time.
}
\details{
The Haversine ('half-versed-sine') formula was published by R.W.
Sinnott in 1984, although it has been known for much longer.
}
\examples{
haversine(53.24007, 6.520386, 53.24054, 6.520386)

}
\references{
Sinnott, R.W, 1984. Virtues of the Haversine. Sky and Telescope
68(2): 159.
}
\author{
Martin Haringa
}
