% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_lines.R
\name{group_lines}
\alias{group_lines}
\title{Groups Lines}
\usage{
group_lines(DT = NULL, threshold = NULL, projection = NULL, id = NULL,
  coords = NULL, timegroup = NULL, splitBy = NULL, spLines = NULL)
}
\arguments{
\item{DT}{input data.table}

\item{threshold}{The width of the buffer around the lines in the units
of the projection. Alternatively, supply 0 to compare intersection without buffering.}

\item{projection}{PROJ.4 character string}

\item{id}{Character string of ID column name}

\item{coords}{Character vector of X coordinate and Y coordinate column names}

\item{timegroup}{(optional) timegroup field in the DT upon which the grouping will be calculated}

\item{splitBy}{(optional) character string or vector of grouping field(s) upon which the grouping will be calculated}

\item{spLines}{Alternatively, provide a SpatialLines object created with the sp
package. If a spLines object is provided, groups cannot be calculated by a
timegroup}
}
\value{
Group by ID (by time) data.table
}
\description{
Groups Lines
}
\examples{
library(data.table)
DT <- fread(system.file("extdata", "DT.csv", package = "spatsoc"))
DT[, datetime := as.POSIXct(datetime,
                            tz = 'UTC')]

utm <- '+proj=utm +zone=36 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs'

group_lines(DT, threshold = 50, projection = utm,
            id = 'ID', coords = c('X', 'Y'))

# Daily movement tracks
group_times(DT, datetime = 'datetime', threshold = '1 day')
group_lines(DT, threshold = 50, projection = utm,
            id = 'ID', coords = c('X', 'Y'),
            timegroup = 'timegroup')

# Daily movement tracks by year
DT[, yr := year(datetime)]
group_lines(DT, threshold = 50, projection = utm,
            id = 'ID', coords = c('X', 'Y'),
            timegroup = 'timegroup',
            splitBy = 'yr')
}
