% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_pts.R
\name{group_pts}
\alias{group_pts}
\title{Group Points}
\usage{
group_pts(DT = NULL, threshold = NULL, id = NULL, coords = NULL,
  timegroup = NULL, splitBy = NULL)
}
\arguments{
\item{DT}{input data.table}

\item{threshold}{for grouping points, in the units of the projection}

\item{id}{Character string of ID column name}

\item{coords}{Character vector of X coordinate and Y coordinate column names}

\item{timegroup}{(optional) timegroup field in the DT upon which the grouping will be calculated}

\item{splitBy}{(optional) character string or vector of grouping field(s) upon which the grouping will be calculated}
}
\value{
Input data.table with column 'group' added.
}
\description{
Group points by spatial and temporal overlap.
}
\details{
This function finds spatialtemporal groups in input points. The threshold provided must be in the units of the projection of the coordinates. UTM coordinates (recommended) are in meters and threshold = 50 indicates a 50m threshold.
}
\examples{
library(data.table)
DT <- fread(system.file("extdata", "DT.csv", package = "spatsoc"))
DT[, datetime := as.POSIXct(datetime,
                            tz = 'UTC')]

# Spatial grouping without timegroup
group_pts(DT, threshold = 5, id = 'ID',
         coords = c('X', 'Y'))

# Temporal grouping
group_times(DT, datetime = 'datetime', threshold = '20 minutes')
# Spatial grouping with timegroup
group_pts(DT, threshold = 5, id = 'ID',
          coords = c('X', 'Y'), timegroup = 'timegroup')

# Spatial grouping with timegroup and splitBy on population
group_pts(DT, threshold = 5, id = 'ID', coords = c('X', 'Y'),
         timegroup = 'timegroup', splitBy = 'population')
}
