\name{plot.im}
\alias{plot.im}
\alias{image.im}
\title{Plot a Pixel Image}
\description{
  Plot a pixel image.
}
\usage{
  \method{plot}{im}(x, \dots, col=NULL,
                   ribbon=TRUE, ribsep=0.15, ribwid=0.05, ribn=1024) 
}
\arguments{
  \item{x}{
    The pixel image to be plotted.
    An object of class \code{"im"} (see \code{\link{im.object}}).
  }
  \item{\dots}{
    Extra arguments passed to \code{\link{image}} to control the plot.
  }
  \item{col}{
    Colours for the pixel values. Either a character vector of colours,
    or an object of class \code{\link{colourmap}}.
  }
  \item{ribbon}{
    Logical flag indicating whether to display a ribbon
    showing the colour map.
  }
  \item{ribsep}{
    Factor controlling the space between the ribbon and the image.
  }
  \item{ribwid}{
    Factor controlling the width of the ribbon.
  }
  \item{ribn}{
    Number of different values to display in the ribbon.
  }
}
\value{
  none.
}
\details{
  This is the \code{plot} method for the class \code{"im"}.
  [It is also the \code{image} method for \code{"im"}.]

  The pixel image \code{x} is displayed on the current plot device,
  using equal scales on the \code{x} and \code{y} axes.

  If \code{ribbon=TRUE}, a legend will be plotted at the right of the
  image. The legend consists of a colour ribbon and an axis with tick-marks,
  showing the correspondence between the pixel values and the colour map.

  Arguments \code{ribsep, ribwid, ribn} control the appearance of the
  ribbon.
  The width of the ribbon is \code{ribwid} times the size of the pixel
  image, where `size' means the larger of the width and the height.
  The distance separating the ribbon and the image is \code{ribsep} times
  the size of the pixel image. The ribbon contains \code{ribn}
  different numerical values, evenly spaced between the minimum and
  maximum pixel values in the image \code{x}, rendered according to
  the chosen colour map.

  The pixel values are displayed using the colours given in the
  argument \code{col}. This may be either an explicit colour map
  (an object of class \code{"colourmap"}, created by the function
  \code{\link{colourmap}}) or a character vector or integer vector
  that specifies a set of colours. 
  
  If \code{col} is an explicit colour map
  (an object of class \code{"colourmap"}) then the same colour
  always represents the same numeric value. For example this ensures
  that when we plot different images, the colour maps are consistent.

  If \code{col} is a character vector or integer vector that specifies
  colours, then the colour mapping will be stretched to match the range of
  pixel values in the image \code{x}. In this case, the mapping of pixel values
  to colours is determined as follows.
  
  \describe{
    \item{logical-valued images:}{the values \code{FALSE} and
      \code{TRUE} are mapped to the colours \code{col[1]} and
      \code{col[2]} respectively.
      The vector \code{col} should have length 2.
    }
    \item{factor-valued images:}{the factor levels \code{levels(x)}
      are mapped to the entries of \code{col} in order. The vector
      \code{col} should have the same length as \code{levels(x)}.
    }
    \item{numeric-valued images:}{
      By default, the range of pixel values in \code{x}
      is divided into \code{n = length(col)}
      equal subintervals, which are mapped to the colours in \code{col}.
      (If \code{col} was not specified, it defaults to a vector of 255
      colours.)
      
      Alternatively if the argument \code{zlim} is given, it should be
      a vector of length 2 specifying an interval of real numbers.
      This interval will be used instead of the range of pixel
      values. The interval from \code{zlim[1]} to \code{zlim[2]} will be
      mapped to the colours in \code{col}. This facility enables the user to
      plot several images using a consistent colour map.

      Alternatively if the argument \code{breaks} is given, then this specifies
      the endpoints of the subintervals that are mapped to each colour.
      This is incompatible with \code{zlim}.
      
      The arguments \code{col} and \code{zlim} or \code{breaks}
      are passed to the function \code{\link{image.default}}.
      For examples of the use of these arguments,
      see \code{\link{image.default}}.
    }
  }
  
  Other graphical parameters controlling the display of both the pixel image
  and the ribbon are passed through the \code{...} arguments
  directly to the function \code{\link{image.default}}.

  To suppress the axis tick marks and labels, set \code{axes=FALSE}.
}
\seealso{
  \code{\link{im.object}},
  \code{\link{colourmap}},
  \code{\link{contour.im}},
  \code{\link{persp.im}},
  \code{\link{image.default}},
  \code{\link{spatstat.options}}
}
\examples{
   # an image
   Z <- setcov(owin())
   plot(Z)
   # stretchable colour map
   plot(Z, col=terrain.colors(128), axes=FALSE)
   # fixed colour map
   tc <- colourmap(rainbow(128), breaks=seq(-1,2,length=129))
   plot(Z, col=tc)
}
\author{Adrian Baddeley
  \email{adrian@maths.uwa.edu.au}
  \url{http://www.maths.uwa.edu.au/~adrian/}
  and Rolf Turner
  \email{r.turner@auckland.ac.nz}
}
\keyword{spatial}
 
\keyword{hplot}
