% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plottingfunctions.R
\name{spplot1}
\alias{spplot1}
\title{spplot1 function}
\usage{
spplot1(x, what, palette = brewer.pal(5, "Oranges"), breaks = NULL,
  legpos = "topleft", fun = identity, include.lowest = TRUE, bty = "n",
  bg = NULL, printlegend = TRUE, bw = FALSE, useLeaflet = FALSE,
  urltemplate = urlTemplate("Stamen_Toner"), fillOpacity = 0.5,
  legendOpacity = 0.5, OSMbg = NULL, leafletLegend = TRUE, ...)
}
\arguments{
\item{x}{a SpatialPolgonsDataFrame or a SpatialPointsDataFrame}

\item{what}{the name of the variable to plot}

\item{palette}{the palette, can either be a vector of names of colours, or a vector of colours produced for example by the brewer.pal function.}

\item{breaks}{optional breaks for the legend, a vector of length 1 + length(palette)}

\item{legpos}{the position of the legend, options are 'topleft', 'topright', 'bottomleft', 'bottomright'}

\item{fun}{an optional function of the data to plot, default is the identity function}

\item{include.lowest}{see ?cut}

\item{bty}{see ?legend}

\item{bg}{see ?legend}

\item{printlegend}{logical: print the legend?}

\item{bw}{Logical. Plot in black/white/greyscale? Default is to produce a colour plot. Useful for producing plots for journals that do not accept colour plots.}

\item{useLeaflet}{whether to use leaflet to produce a zoomable map this requires the leaflet package, available by issuing the command "devtools::install_github('rstudio/leaflet')"}

\item{urltemplate}{template for leaflet map background, default is urlTemplate('Stamen-Toner'), but any valid web address for leaflet templates will work here. See ?urlTemplate.}

\item{fillOpacity}{see ?addPolygons}

\item{legendOpacity}{see opacity argument in function addLegend}

\item{OSMbg}{optional OpenStreetMap background to add to plot, obtain this using the function getBackground}

\item{leafletLegend}{logical, display the leaflet legend?}

\item{...}{other arguments to be passed to plot}
}
\value{
either produces a plot or if useLeaflet is TRUE, returns a leaflet map widget to which further layers can be added
}
\description{
A function to provide spplot-like plotting capability but NOT using trellis graphics. This function also acts as an interface for fast
plotting of SpatialPolygonsDataFrame or SpatialPixelsDataFrame objects using leaflet HTML plotting capabilities to get zoomable plots
with real-world context: transformation to the correct projection is done automatically.
}
\details{
See \url{http://leaflet-extras.github.io/leaflet-providers/preview/} for examples of  leaflet templates.

Instructions on installing the leaflet R package are available from  \url{https://rstudio.github.io/leaflet/}
}
\seealso{
\link{urlTemplate}, \link{getBackground}, brewer.pal
}

