% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformations.R
\name{rotate.scale.coords}
\alias{rotate.scale.coords}
\title{Scale and rotate points from the unit square to a defined projection.}
\usage{
rotate.scale.coords(coords, bb, back = TRUE)
}
\arguments{
\item{coords}{Output from RSHalton() to be converted to the spatial surface of interest.}

\item{bb}{Special shape file defining the bounding box with attributes for centroid and rotation.}

\item{back}{Boolean for whether or not the rotation is back to the original rotated bounding box.}
}
\value{
sf spatial points with projection defined in bb.
}
\description{
Given some coordinates on [0,1)x[0,1), shift and scale them to the bounding box, and then rotate
them given the bounding box rotation defined by the Master Sample.
}
\author{
This function was first written by Paul van Dam-Bates for the
package BASMasterSample.
}
\keyword{internal}
