% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logreg.R
\name{SPCModellogregLikRatio}
\alias{SPCModellogregLikRatio}
\title{Data Model for Binary Responses using a logarithmic model and likelihood ratio updates.}
\usage{
SPCModellogregLikRatio(formula, Delta = 1)
}
\arguments{
\item{formula}{The formula of the model.}

\item{Delta}{This value will be added to the log odds ratio in the
out-of-control model in the likelihood ratio between the
out-of-control and the in-control model constituting the updates.}
}
\description{
Data Model for Binary Responses using a logarithmic model and likelihood ratio updates.
}
\examples{
n <- 1000
Xlogreg <- data.frame(x1=rbinom(n,1,0.4), x2=runif(n,0,1), x3=rnorm(n))
xbeta <- -1+Xlogreg$x1*100+Xlogreg$x2+Xlogreg$x3
Xlogreg$y <- rbinom(n,1,exp(xbeta)/(1+exp(xbeta)))
chartlogreg <- new("SPCCUSUM",
                   model=SPCModellogregLikRatio(Delta= 1, formula="y~x1+x2+x3"))
SPCproperty(data=Xlogreg,nrep=10,property="calARL",
            chart=chartlogreg,params=list(target=100))
#increase nrep for real applications.
}

