% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specs.R
\name{specs}
\alias{specs}
\title{SPECS}
\usage{
specs(
  y,
  x,
  p = 1,
  deterministics = c("constant", "trend", "both", "none"),
  ADL = FALSE,
  weights = c("ridge", "ols", "none"),
  k_delta = 1,
  k_pi = 1,
  lambda_g = NULL,
  lambda_i = NULL,
  thresh = 1e-04,
  max_iter_delta = 1e+05,
  max_iter_pi = 1e+05,
  max_iter_gamma = 1e+05
)
}
\arguments{
\item{y}{A vector containing the dependent variable in levels.}

\item{x}{A matrix containing the independent variables in levels.}

\item{p}{Integer indicating the desired number of lagged differences to include. Default is 1.}

\item{deterministics}{A character object indicating which deterministic variables should be added
("none","constant","trend","both"). Default is "constant".}

\item{ADL}{Logical object indicating whether an ADL model without error-correction term should be estimated.
Default is FALSE.}

\item{weights}{Choice of penalty weights. The weights can be automatically generated by ridge regression (default)
or ols. Alternatively, a conformable vector of non-negative weights can be supplied or no weights can be applied.}

\item{k_delta}{The power to which the weights for delta should be raised, if weights are set to "ridge" or "ols".}

\item{k_pi}{The power to which the weights for pi should be raised, if weights are set to "ridge" or "ols".}

\item{lambda_g}{An optional user-specified grid for the group penalty may be supplied. If left empty,
a 10-dimensional grid containing 0 as the minimum value is generated.}

\item{lambda_i}{An optional user-specified grid for the individual penalty may be supplied. If left empty,
a 10-dimensional grid containing 0 as the minimum value is generated.}

\item{thresh}{The treshold for convergence.}

\item{max_iter_delta}{Maximum number of updates for delta. Default is \eqn{10^5}.}

\item{max_iter_pi}{Maximum number of updates for pi. Default is \eqn{10^5}.}

\item{max_iter_gamma}{Maximum number of updates for gamma. Default is \eqn{10^5}.}
}
\value{
\item{D}{A matrix containing the deterministic variables included in the model.}
\item{gammas}{A matrix containing the estimated coefficients of
the stochastic variables in the conditional error-correction model.}
\item{lambda_g}{The grid of group penalties.}
\item{lambda_i}{The grid of individual penalties.}
\item{Mv}{A matrix containing the independent variables, after regressing out the deterministic components.}
\item{My_d}{A vector containing the dependent variable, after regressing out the deterministic components.}
\item{theta}{The estimated coefficients for the constant and trend. If a deterministic component is excluded,
its coefficient is set to zero.}
\item{v}{A matrix containing the independent variables (excluding deterministic components).}
\item{weights}{The vector of penalty weights.}
\item{y_d}{A vector containing the dependent variable, i.e. the differences of y.}
}
\description{
This function estimates the Single-equation Penalized Error Correction Selector
as described in Smeekes and Wijler (2020). The function takes a dependent variable \eqn{y} and a matrix of independent
variables x as input, and transforms it to a conditional error correction model. This model is estimated by means of
penalized regression, involving \eqn{L1}-penalty on individual coefficients and a potential \eqn{L2}-penalty
on the coefficients of the lagged levels in the model, see Smeekes and Wijler (2020) for details.
}
\details{
The function can generate an automated sequence of penalty parameters and offers the option to compute and include adaptive
penalty weights. In addition, it is possible to estimate a penalized ADL model in differences by excluding the lagged levels
from the model. For automated selection of an optimal penalty value, see the function specs_opt(...).
}
\examples{

#Estimate a model for unemployment and ten google trends

#Organize data
y <- Unempl_GT[,1]
index_GT <- sample(c(2:ncol(Unempl_GT)),10)
x <- Unempl_GT[,index_GT]

#Estimate a CECM with 1 lagged differences
my_specs <- specs(y,x,p=1)

#Estimate a CECM with 1 lagged differences and no group penalty
my_specs2 <- specs(y,x,p=1,lambda_g=0)

#Estimate an autoregressive distributed lag model with 2 lagged differences
my_specs3 <- specs(y,x,ADL=TRUE,p=2)
}
