% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_spectra.R
\name{read_spectra}
\alias{read_spectra}
\title{Read files from various formats into `spectra`}
\usage{
read_spectra(
  path,
  format = NULL,
  type = "target_reflectance",
  extract_metadata = FALSE,
  exclude_if_matches = NULL,
  ignore_extension = FALSE
)
}
\arguments{
\item{path}{Path to directory or input files.}

\item{format}{File format. Defaults to NULL so spectrolab tries to guess it
from the file name. Alternatively, use "asd" for ASD; "sig"
for SVC (Spectra Vista); or "sed" for PSR (Spectral Evolution)}

\item{type}{Data type to read. "target_reflectance", "target_radiance", or
"reference_radiance". Defaults to "target_reflectance".}

\item{extract_metadata}{Boolean. Defaults to FALSE. Only implemented for the
Spectra Vista (.sig) and Spectral Evolution (.sed)
file types.}

\item{exclude_if_matches}{excludes files that match this regular expression.
Example: "BAD"}

\item{ignore_extension}{Boolean. If TRUE, the parser will try to read every
file in path regardless of the expected extension.}
}
\value{
a single `spectra` or a list of `spectra` (in case files have
        incompatible band number or bands values)
}
\description{
Read files from various formats into `spectra`
}
\examples{
library(spectrolab)
dir_path = system.file("extdata", "Acer_example", package = "spectrolab")

spec     = read_spectra(path = dir_path, format = "sig")
}
\author{
Jose Eduardo Meireles
}
