% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot.spectra}
\alias{plot.spectra}
\title{Plot spectra}
\usage{
\method{plot}{spectra}(x, ylab = "Reflectance", xlab = "Wavelength",
  col = "black", lty = 1, type = "l", ...)
}
\arguments{
\item{x}{spectra object}

\item{ylab}{label for y axis. Defaults to "Reflectance".}

\item{xlab}{label for x axis. Defaults to "Wavelength".}

\item{col}{line color. Defaults to "black".}

\item{lty}{line type. Defaults to 1.}

\item{type}{type of plot. Meant to take either line "l" or no plotting "n".}

\item{...}{other arguments passed to matplot.}
}
\value{
nothing. Called for side effect.
}
\description{
\code{plot} plots spectra.
}
\examples{
library(spectrolab)
spec  = as.spectra(spec_matrix_example, name_idx = 1)
plot(spec, lwd = 1.2)
}
\author{
Jose Eduardo Meireles
}
