/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.DockController;
import bibliothek.gui.DockFrontend;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CSetting;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.layout.CLayoutChangeStrategy;
import bibliothek.gui.dock.common.mode.CLocationModeManager;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationSettingConverter;
import bibliothek.gui.dock.frontend.Setting;
import bibliothek.gui.dock.support.mode.ModeSettings;

public class CDockFrontend
extends DockFrontend {
    private CControlAccess control;

    public CDockFrontend(CControlAccess cControlAccess, DockController dockController) {
        super(dockController);
        this.control = cControlAccess;
        this.setLayoutChangeStrategy(new CLayoutChangeStrategy(cControlAccess.getOwner()));
    }

    public void remove(Dockable dockable) {
        CDockable cDockable;
        String string;
        if (dockable instanceof CommonDockable && (string = this.control.shouldStore(cDockable = ((CommonDockable)dockable).getDockable())) != null) {
            this.addEmpty(string);
        }
        super.remove(dockable);
    }

    protected Setting createSetting() {
        CSetting cSetting = new CSetting();
        CLocationModeManager cLocationModeManager = this.control.getLocationManager();
        ModeSettings<Location, Location> modeSettings = cLocationModeManager.createSettings(new LocationSettingConverter());
        cSetting.setModes(modeSettings);
        return cSetting;
    }

    public Setting getSetting(boolean bl) {
        CLocationModeManager cLocationModeManager = this.control.getLocationManager();
        CSetting cSetting = (CSetting)super.getSetting(bl);
        ModeSettings<Location, Location> modeSettings = cLocationModeManager.createSettings(new LocationSettingConverter());
        cSetting.setModes(modeSettings);
        cLocationModeManager.writeSettings(modeSettings);
        this.control.fillMultiFactories(cSetting);
        return cSetting;
    }

    public void setSetting(final Setting setting, final boolean bl) {
        CLocationModeManager cLocationModeManager = this.control.getLocationManager();
        if (bl) {
            cLocationModeManager.resetWorkingAreaChildren();
        }
        cLocationModeManager.readSettings(((CSetting)setting).getModes());
        cLocationModeManager.runLayoutTransaction(new Runnable(){

            public void run() {
                CDockFrontend.super.setSetting(setting, bl);
            }
        });
        cLocationModeManager.ensureBasicModes();
        cLocationModeManager.refresh();
    }
}

