/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.ui;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.accept.DockAcceptance;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.CLocationModeManager;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingAreaAcceptance
implements DockAcceptance {
    private CControlAccess control;

    public WorkingAreaAcceptance(CControlAccess cControlAccess) {
        this.control = cControlAccess;
    }

    @Override
    public boolean accept(DockStation dockStation, Dockable dockable, Dockable dockable2) {
        return this.accept(dockStation, dockable2);
    }

    @Override
    public boolean accept(DockStation dockStation, Dockable dockable) {
        CLocationModeManager cLocationModeManager = this.control.getLocationManager();
        if (cLocationModeManager.isOnTransaction()) {
            return true;
        }
        ExtendedMode extendedMode = cLocationModeManager.getMode(dockable);
        if (extendedMode == null && (extendedMode = cLocationModeManager.childsExtendedMode(dockStation)) == null) {
            return true;
        }
        CLocationMode cLocationMode = (CLocationMode)cLocationModeManager.getMode(extendedMode.getModeIdentifier());
        if (cLocationMode == null) {
            return true;
        }
        if (!cLocationMode.respectWorkingAreas(dockStation)) {
            return true;
        }
        CStation<?> cStation = this.searchArea(dockStation);
        return this.match(cStation, dockable);
    }

    private CStation<?> searchArea(DockElement dockElement) {
        CStation<?> cStation2;
        HashMap hashMap = new HashMap();
        for (CStation<?> cStation2 : this.control.getOwner().getStations()) {
            if (!cStation2.isWorkingArea()) continue;
            hashMap.put(cStation2.getStation(), cStation2);
        }
        Object object = dockElement.asDockStation();
        cStation2 = dockElement.asDockable();
        while (cStation2 != null || object != null) {
            CStation cStation3;
            if (object != null && (cStation3 = (CStation)hashMap.get(object)) != null) {
                return cStation3;
            }
            cStation2 = object == null ? null : object.asDockable();
            object = cStation2 == null ? null : cStation2.getDockParent();
        }
        return null;
    }

    private boolean match(CStation<?> cStation, Dockable dockable) {
        Object object;
        CStation<?> cStation2;
        if (dockable instanceof CommonDockable && (cStation2 = (object = ((CommonDockable)dockable).getDockable()).getWorkingArea()) != cStation) {
            return false;
        }
        object = dockable.asDockStation();
        if (object != null) {
            if (dockable instanceof CommonDockable && (cStation2 = ((CommonDockable)dockable).getStation()) != null && cStation2.isWorkingArea()) {
                return true;
            }
            return this.match(cStation, (DockStation)object);
        }
        return true;
    }

    private boolean match(CStation<?> cStation, DockStation dockStation) {
        int n = dockStation.getDockableCount();
        for (int i = 0; i < n; ++i) {
            boolean bl = this.match(cStation, dockStation.getDockable(i));
            if (bl) continue;
            return false;
        }
        return true;
    }
}

