/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.location;

import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.location.AbstractTreeLocation;
import bibliothek.gui.dock.common.location.CRectangleLocation;
import bibliothek.gui.dock.common.location.CStackLocation;
import bibliothek.gui.dock.common.location.Side;
import bibliothek.gui.dock.common.location.TreeLocationRoot;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.split.SplitDockPathProperty;
import bibliothek.gui.dock.station.split.SplitDockPlaceholderProperty;
import bibliothek.gui.dock.station.split.SplitDockProperty;

public abstract class CSplitLocation
extends CLocation {
    public CLocation aside() {
        return this;
    }

    public CRectangleLocation rectangle(double d, double d2, double d3, double d4) {
        return new CRectangleLocation(this, d, d2, d3, d4);
    }

    public CStackLocation stack() {
        return this.rectangle(0.0, 0.0, 1.0, 1.0).stack();
    }

    public CStackLocation stack(int n) {
        return this.rectangle(0.0, 0.0, 1.0, 1.0).stack(n);
    }

    public TreeLocationRoot north(double d) {
        return this.north(d, -1L);
    }

    public TreeLocationRoot north(double d, long l) {
        return new TreeLocationRoot(this, d, Side.NORTH, l);
    }

    public TreeLocationRoot south(double d) {
        return this.south(d, -1L);
    }

    public TreeLocationRoot south(double d, long l) {
        return new TreeLocationRoot(this, d, Side.SOUTH, l);
    }

    public TreeLocationRoot east(double d) {
        return this.east(d, -1L);
    }

    public TreeLocationRoot east(double d, long l) {
        return new TreeLocationRoot(this, d, Side.EAST, l);
    }

    public TreeLocationRoot west(double d) {
        return this.west(d, -1L);
    }

    public TreeLocationRoot west(double d, long l) {
        return new TreeLocationRoot(this, d, Side.WEST, l);
    }

    public CLocation expandProperty(DockableProperty dockableProperty) {
        DockableProperty dockableProperty2;
        CLocation cLocation = null;
        if (dockableProperty instanceof SplitDockPlaceholderProperty) {
            dockableProperty = ((SplitDockPlaceholderProperty)dockableProperty).getBackup();
        }
        if (dockableProperty instanceof SplitDockProperty) {
            dockableProperty2 = (SplitDockProperty)dockableProperty;
            cLocation = this.rectangle(((SplitDockProperty)dockableProperty2).getX(), ((SplitDockProperty)dockableProperty2).getY(), ((SplitDockProperty)dockableProperty2).getWidth(), ((SplitDockProperty)dockableProperty2).getHeight());
        } else if (dockableProperty instanceof SplitDockPathProperty) {
            dockableProperty2 = (SplitDockPathProperty)dockableProperty;
            if (((SplitDockPathProperty)dockableProperty2).size() > 0) {
                AbstractTreeLocation abstractTreeLocation = null;
                SplitDockPathProperty.Node node = ((SplitDockPathProperty)dockableProperty2).getNode(0);
                switch (node.getLocation()) {
                    case BOTTOM: {
                        abstractTreeLocation = this.south(node.getSize(), node.getId());
                        break;
                    }
                    case LEFT: {
                        abstractTreeLocation = this.west(node.getSize(), node.getId());
                        break;
                    }
                    case RIGHT: {
                        abstractTreeLocation = this.east(node.getSize(), node.getId());
                        break;
                    }
                    case TOP: {
                        abstractTreeLocation = this.north(node.getSize(), node.getId());
                    }
                }
                int n = ((SplitDockPathProperty)dockableProperty2).size();
                block12: for (int i = 1; i < n; ++i) {
                    node = ((SplitDockPathProperty)dockableProperty2).getNode(i);
                    switch (node.getLocation()) {
                        case BOTTOM: {
                            abstractTreeLocation = abstractTreeLocation.south(node.getSize(), node.getId());
                            continue block12;
                        }
                        case LEFT: {
                            abstractTreeLocation = abstractTreeLocation.west(node.getSize(), node.getId());
                            continue block12;
                        }
                        case RIGHT: {
                            abstractTreeLocation = abstractTreeLocation.east(node.getSize(), node.getId());
                            continue block12;
                        }
                        case TOP: {
                            abstractTreeLocation = abstractTreeLocation.north(node.getSize(), node.getId());
                        }
                    }
                }
                cLocation = abstractTreeLocation.leaf(((SplitDockPathProperty)dockableProperty2).getLeafId());
            } else {
                cLocation = this.rectangle(0.0, 0.0, 1.0, 1.0);
            }
        }
        dockableProperty2 = dockableProperty.getSuccessor();
        if (dockableProperty2 == null) {
            return cLocation;
        }
        return cLocation.expandProperty(dockableProperty2);
    }

    public ExtendedMode findMode() {
        return ExtendedMode.NORMALIZED;
    }

    public DockableProperty findProperty(DockableProperty dockableProperty) {
        SplitDockProperty splitDockProperty = new SplitDockProperty(0.0, 0.0, 1.0, 1.0);
        splitDockProperty.setSuccessor(dockableProperty);
        return splitDockProperty;
    }
}

