/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.mode.station;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.location.CMaximizedLocation;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.CLocationModeManager;
import bibliothek.gui.dock.common.mode.CMaximizedModeArea;
import bibliothek.gui.dock.common.mode.CNormalModeArea;
import bibliothek.gui.dock.event.DockRelocatorAdapter;
import bibliothek.gui.dock.event.DockRelocatorListener;
import bibliothek.gui.dock.event.SplitDockListener;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeEvent;
import bibliothek.gui.dock.facile.mode.MaximizedMode;
import bibliothek.gui.dock.facile.mode.MaximizedModeArea;
import bibliothek.gui.dock.facile.mode.ModeArea;
import bibliothek.gui.dock.facile.mode.ModeAreaListener;
import bibliothek.gui.dock.facile.mode.NormalMode;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.station.split.SplitDockFullScreenProperty;
import bibliothek.gui.dock.station.split.SplitDockTree;
import bibliothek.gui.dock.support.mode.AffectedSet;
import bibliothek.gui.dock.support.mode.AffectingRunnable;
import bibliothek.gui.dock.util.DockUtilities;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSplitDockStationHandle {
    private CStation<SplitDockStation> station;
    private Normal normal = new Normal();
    private Maximal maximal = new Maximal();
    private LocationMode normalMode;
    private MaximizedMode<?> maximizedMode;
    private CLocationModeManager manager;
    private List<ModeAreaListenerWrapper> listeners = new ArrayList<ModeAreaListenerWrapper>();
    private SplitDockListener fullScreenListener = new SplitDockListener(){

        public void fullScreenDockableChanged(SplitDockStation splitDockStation, Dockable dockable, Dockable dockable2) {
            ModeAreaListenerWrapper[] modeAreaListenerWrapperArray;
            HashSet<Dockable> hashSet = new HashSet<Dockable>();
            if (dockable != null) {
                hashSet.add(dockable);
            }
            if (dockable2 != null) {
                hashSet.add(dockable2);
            }
            for (ModeAreaListenerWrapper modeAreaListenerWrapper : modeAreaListenerWrapperArray = CSplitDockStationHandle.this.listeners.toArray(new ModeAreaListenerWrapper[CSplitDockStationHandle.this.listeners.size()])) {
                modeAreaListenerWrapper.fire(hashSet);
            }
        }
    };
    private DockRelocatorListener relocatorListener = new DockRelocatorAdapter(){

        public void drop(DockController dockController, Dockable dockable, DockStation dockStation) {
            MaximizedModeArea maximizedModeArea = CSplitDockStationHandle.this.maximizedMode.getNextMaximizeArea(dockStation);
            if (maximizedModeArea == CSplitDockStationHandle.this.maximal) {
                CSplitDockStationHandle.this.manager.runTransaction(new AffectingRunnable(){

                    public void run(AffectedSet affectedSet) {
                        CSplitDockStationHandle.this.maximizedMode.unmaximize(CSplitDockStationHandle.this.getStation(), affectedSet);
                    }
                });
            }
        }
    };

    public CSplitDockStationHandle(CStation<SplitDockStation> cStation, CLocationModeManager cLocationModeManager) {
        this.station = cStation;
        this.manager = cLocationModeManager;
    }

    private void add(ModeAreaListenerWrapper modeAreaListenerWrapper) {
        if (modeAreaListenerWrapper == null) {
            throw new IllegalArgumentException("listener must not be empty");
        }
        if (this.listeners.isEmpty()) {
            this.station.getStation().addSplitDockStationListener(this.fullScreenListener);
        }
        this.listeners.add(modeAreaListenerWrapper);
    }

    private void remove(ModeAreaListenerWrapper modeAreaListenerWrapper) {
        this.listeners.remove(modeAreaListenerWrapper);
        if (this.listeners.isEmpty()) {
            this.station.getStation().removeSplitDockStationListener(this.fullScreenListener);
        }
    }

    public SplitDockStation getStation() {
        return this.station.getStation();
    }

    public CNormalModeArea asNormalModeArea() {
        return this.normal;
    }

    public CMaximizedModeArea asMaximziedModeArea() {
        return this.maximal;
    }

    public void dropAside(Dockable dockable) {
        if (dockable.getDockParent() == this.station) {
            throw new IllegalStateException("dockable already a child");
        }
        SplitDockTree splitDockTree = this.getStation().createTree();
        if (splitDockTree.getRoot() == null) {
            splitDockTree.root(dockable);
        } else {
            splitDockTree.root(splitDockTree.horizontal(splitDockTree.put(dockable), splitDockTree.unroot()));
        }
        this.getStation().dropTree(splitDockTree, false);
    }

    protected class Maximal
    implements CMaximizedModeArea {
        private DockController controller;

        protected Maximal() {
        }

        public void addModeAreaListener(ModeAreaListener modeAreaListener) {
            CSplitDockStationHandle.this.add(new ModeAreaListenerWrapper(this, modeAreaListener));
        }

        public void removeModeAreaListener(ModeAreaListener modeAreaListener) {
            CSplitDockStationHandle.this.remove(new ModeAreaListenerWrapper(this, modeAreaListener));
        }

        public void setMode(LocationMode locationMode) {
            if (CSplitDockStationHandle.this.maximizedMode != null) {
                throw new IllegalStateException("handle already in use");
            }
            CSplitDockStationHandle.this.maximizedMode = (MaximizedMode)locationMode;
        }

        public void setController(DockController dockController) {
            if (this.controller != null) {
                this.controller.getRelocator().removeDockRelocatorListener(CSplitDockStationHandle.this.relocatorListener);
            }
            this.controller = dockController;
            if (dockController != null) {
                dockController.getRelocator().addDockRelocatorListener(CSplitDockStationHandle.this.relocatorListener);
            }
        }

        public boolean autoDefaultArea() {
            return true;
        }

        public LocationMode getUnmaximizedMode() {
            return CSplitDockStationHandle.this.normalMode;
        }

        public void prepareApply(Dockable dockable, AffectedSet affectedSet) {
            CLocationMode cLocationMode = (CLocationMode)CSplitDockStationHandle.this.manager.getMode(NormalMode.IDENTIFIER);
            if (cLocationMode != null) {
                CSplitDockStationHandle.this.manager.apply(dockable, cLocationMode, affectedSet, false);
            }
        }

        public void prepareApply(Dockable dockable, Location location, AffectedSet affectedSet) {
            CLocationMode cLocationMode;
            boolean bl;
            boolean bl2 = bl = location != null && location.getLocation() instanceof SplitDockFullScreenProperty;
            if (!bl && (cLocationMode = (CLocationMode)CSplitDockStationHandle.this.manager.getMode(NormalMode.IDENTIFIER)) != null) {
                CSplitDockStationHandle.this.manager.apply(dockable, cLocationMode, affectedSet, false);
            }
        }

        public Runnable onApply(LocationModeEvent locationModeEvent) {
            Object object;
            DockableProperty dockableProperty;
            if (locationModeEvent.isDone()) {
                return null;
            }
            Location location = locationModeEvent.getLocation();
            Dockable dockable = locationModeEvent.getDockable();
            DockableProperty dockableProperty2 = dockableProperty = location == null ? null : location.getLocation();
            if (locationModeEvent.getMode().getUniqueIdentifier().equals(NormalMode.IDENTIFIER) && dockableProperty != null && dockableProperty.getSuccessor() == null) {
                Object object2;
                object = (CLocationMode)CSplitDockStationHandle.this.manager.getCurrentMode(dockable);
                CLocationMode cLocationMode = (CLocationMode)CSplitDockStationHandle.this.manager.getPreviousMode(dockable);
                if (object != null && cLocationMode != null && NormalMode.IDENTIFIER.equals(cLocationMode.getUniqueIdentifier()) && MaximizedMode.IDENTIFIER.equals(object.getUniqueIdentifier()) && (object2 = (MaximizedModeArea)CSplitDockStationHandle.this.maximizedMode.get(location.getRoot())) == this) {
                    object2.setMaximized(dockable, false, null, locationModeEvent.getAffected());
                    locationModeEvent.done();
                    return null;
                }
            }
            if (location != null && this.getMaximized() != null) {
                object = CSplitDockStationHandle.this.manager.getRepresentations(location.getRoot());
                for (Object object2 : object.values()) {
                    if (!DockUtilities.isAncestor(this.getStation(), (DockElement)object2)) continue;
                    CSplitDockStationHandle.this.maximizedMode.unmaximize(this, locationModeEvent.getAffected());
                    break;
                }
            }
            if (CSplitDockStationHandle.this.maximizedMode != null && locationModeEvent.getMode().getUniqueIdentifier().equals(NormalMode.IDENTIFIER) && (object = CSplitDockStationHandle.this.maximizedMode.getMaximizeArea(dockable)) == this) {
                CSplitDockStationHandle.this.maximizedMode.unmaximize(dockable, locationModeEvent.getAffected());
            }
            return null;
        }

        public Runnable onApply(final LocationModeEvent locationModeEvent, final Dockable dockable) {
            if (locationModeEvent.isDone()) {
                return null;
            }
            if (!locationModeEvent.getMode().getUniqueIdentifier().equals(NormalMode.IDENTIFIER)) {
                CSplitDockStationHandle.this.maximizedMode.unmaximize(this.getStation().getFullScreen(), locationModeEvent.getAffected());
                return new Runnable(){

                    public void run() {
                        if (dockable != null && dockable.getDockParent() != null) {
                            CSplitDockStationHandle.this.maximizedMode.maximize(Maximal.this, dockable, locationModeEvent.getAffected());
                        }
                    }
                };
            }
            return null;
        }

        public String getUniqueId() {
            return CSplitDockStationHandle.this.station.getUniqueId();
        }

        public boolean isChild(Dockable dockable) {
            return this.getStation().getFullScreen() == dockable;
        }

        public SplitDockStation getStation() {
            return (SplitDockStation)CSplitDockStationHandle.this.station.getStation();
        }

        public boolean respectWorkingAreas() {
            return false;
        }

        public Dockable[] getMaximized() {
            Dockable dockable = this.getStation().getFullScreen();
            if (dockable == null) {
                return null;
            }
            return new Dockable[]{dockable};
        }

        public void setMaximized(Dockable dockable, boolean bl, Location location, AffectedSet affectedSet) {
            SplitDockStation splitDockStation = this.getStation();
            if (!bl) {
                if (splitDockStation.getFullScreen() != null && DockUtilities.isAncestor(splitDockStation.getFullScreen(), dockable)) {
                    splitDockStation.setFullScreen(null);
                }
            } else {
                DockableProperty dockableProperty;
                DockableProperty dockableProperty2 = dockableProperty = location == null ? null : location.getLocation();
                if (dockableProperty instanceof SplitDockFullScreenProperty && this.getMaximized() != null && this.getStation().drop(dockable, dockableProperty)) {
                    return;
                }
                if (dockable.getDockParent() == splitDockStation) {
                    splitDockStation.setFullScreen(dockable);
                } else {
                    if (dockable.getDockParent() != null) {
                        dockable.getDockParent().drag(dockable);
                    }
                    CSplitDockStationHandle.this.dropAside(dockable);
                    splitDockStation.setFullScreen(dockable);
                }
            }
            affectedSet.add(dockable);
        }

        public boolean isRepresenting(DockStation dockStation) {
            return dockStation == CSplitDockStationHandle.this.station.getStation();
        }

        public CLocation getCLocation(Dockable dockable) {
            CLocation cLocation = CSplitDockStationHandle.this.station.getStationLocation();
            DockableProperty dockableProperty = DockUtilities.getPropertyChain(this.getStation(), dockable);
            if (dockableProperty != null) {
                dockableProperty = dockableProperty.getSuccessor();
            }
            CMaximizedLocation cMaximizedLocation = new CMaximizedLocation(cLocation.findRoot());
            if (dockableProperty != null) {
                return cMaximizedLocation.expandProperty(dockableProperty);
            }
            return cMaximizedLocation;
        }

        public CLocation getCLocation(Dockable dockable, Location location) {
            return this.getCLocation(dockable);
        }
    }

    protected class Normal
    implements CNormalModeArea {
        protected Normal() {
        }

        public void setMode(LocationMode locationMode) {
            CSplitDockStationHandle.this.normalMode = locationMode;
        }

        public void addModeAreaListener(ModeAreaListener modeAreaListener) {
            CSplitDockStationHandle.this.add(new ModeAreaListenerWrapper(this, modeAreaListener));
        }

        public void removeModeAreaListener(ModeAreaListener modeAreaListener) {
            CSplitDockStationHandle.this.remove(new ModeAreaListenerWrapper(this, modeAreaListener));
        }

        public boolean autoDefaultArea() {
            return true;
        }

        public void setController(DockController dockController) {
        }

        public boolean isNormalModeChild(Dockable dockable) {
            return this.isChild(dockable) && this.getStation().getFullScreen() != dockable;
        }

        public DockableProperty getLocation(Dockable dockable) {
            return DockUtilities.getPropertyChain(this.getStation(), dockable);
        }

        public String getUniqueId() {
            return CSplitDockStationHandle.this.station.getUniqueId();
        }

        public boolean isChild(Dockable dockable) {
            return dockable.getDockParent() == this.getStation() && !CSplitDockStationHandle.this.maximal.isChild(dockable);
        }

        public SplitDockStation getStation() {
            return (SplitDockStation)CSplitDockStationHandle.this.station.getStation();
        }

        public boolean respectWorkingAreas() {
            return true;
        }

        public void setLocation(Dockable dockable, DockableProperty dockableProperty, AffectedSet affectedSet) {
            Dockable dockable2 = this.getStation().getFullScreen();
            if (dockable2 != null) {
                CSplitDockStationHandle.this.maximal.setMaximized(dockable2, false, null, affectedSet);
            }
            affectedSet.add(dockable);
            if (dockable.getDockParent() == CSplitDockStationHandle.this.station.getStation()) {
                if (dockableProperty != null) {
                    this.getStation().move(dockable, dockableProperty);
                }
            } else {
                if (dockableProperty != null && !this.getStation().drop(dockable, dockableProperty)) {
                    dockableProperty = null;
                }
                if (dockableProperty == null && !DockUtilities.isAncestor(CSplitDockStationHandle.this.station.getStation(), dockable)) {
                    this.getStation().drop(dockable);
                }
            }
        }

        public CLocation getCLocation(Dockable dockable) {
            DockableProperty dockableProperty = DockUtilities.getPropertyChain(this.getStation(), dockable);
            return CSplitDockStationHandle.this.station.getStationLocation().expandProperty(dockableProperty);
        }

        public CLocation getCLocation(Dockable dockable, Location location) {
            DockableProperty dockableProperty = location.getLocation();
            if (dockableProperty == null) {
                return CSplitDockStationHandle.this.station.getStationLocation();
            }
            return CSplitDockStationHandle.this.station.getStationLocation().expandProperty(dockableProperty);
        }

        public CLocation getBaseLocation() {
            return CSplitDockStationHandle.this.station.getStationLocation();
        }

        public boolean isWorkingArea() {
            return CSplitDockStationHandle.this.station.isWorkingArea();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModeAreaListenerWrapper {
        private ModeAreaListener listener;
        private ModeArea area;

        public ModeAreaListenerWrapper(ModeArea modeArea, ModeAreaListener modeAreaListener) {
            this.area = modeArea;
            this.listener = modeAreaListener;
        }

        public void fire(Set<Dockable> set) {
            this.listener.internalLocationChange(this.area, set);
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ModeAreaListenerWrapper) {
                ModeAreaListenerWrapper modeAreaListenerWrapper = (ModeAreaListenerWrapper)object;
                return modeAreaListenerWrapper.area.equals(this.area) && modeAreaListenerWrapper.listener.equals(this.listener);
            }
            return false;
        }

        public int hashCode() {
            return this.area.hashCode() ^ this.listener.hashCode();
        }
    }
}

