/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.theme;

import bibliothek.extension.gui.dock.theme.FlatTheme;
import bibliothek.gui.DockController;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.action.CPanelPopup;
import bibliothek.gui.dock.common.intern.action.panel.FlatPanelPopupGenerator;
import bibliothek.gui.dock.common.intern.action.panel.PanelDropDownGenerator;
import bibliothek.gui.dock.common.intern.action.panel.PanelMenuGenerator;
import bibliothek.gui.dock.common.intern.color.BasicButtonTitleTransmitter;
import bibliothek.gui.dock.common.intern.color.FlatTabTransmitter;
import bibliothek.gui.dock.common.intern.color.FlatTitleTransmitter;
import bibliothek.gui.dock.common.theme.CDockTheme;
import bibliothek.gui.dock.themes.ColorBridgeFactory;
import bibliothek.gui.dock.themes.NoStackTheme;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.ColorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFlatTheme
extends CDockTheme<FlatTheme> {
    public CFlatTheme(CControl cControl, FlatTheme flatTheme) {
        super(flatTheme);
        this.init(cControl);
    }

    public CFlatTheme(CControl cControl) {
        this(new FlatTheme());
        this.init(cControl);
    }

    private CFlatTheme(FlatTheme flatTheme) {
        super(flatTheme, new NoStackTheme(flatTheme));
    }

    private void init(final CControl cControl) {
        this.putColorBridgeFactory(TabColor.KIND_TAB_COLOR, new ColorBridgeFactory(){

            public ColorBridge create(ColorManager colorManager) {
                FlatTabTransmitter flatTabTransmitter = new FlatTabTransmitter(colorManager);
                flatTabTransmitter.setControl(cControl);
                return flatTabTransmitter;
            }
        });
        this.putColorBridgeFactory(TitleColor.KIND_TITLE_COLOR, new ColorBridgeFactory(){

            public ColorBridge create(ColorManager colorManager) {
                FlatTitleTransmitter flatTitleTransmitter = new FlatTitleTransmitter(colorManager);
                flatTitleTransmitter.setControl(cControl);
                return flatTitleTransmitter;
            }
        });
        this.putColorBridgeFactory(TitleColor.KIND_FLAP_BUTTON_COLOR, new ColorBridgeFactory(){

            public ColorBridge create(ColorManager colorManager) {
                BasicButtonTitleTransmitter basicButtonTitleTransmitter = new BasicButtonTitleTransmitter(colorManager);
                basicButtonTitleTransmitter.setControl(cControl);
                return basicButtonTitleTransmitter;
            }
        });
        this.initDefaultFontBridges(cControl);
    }

    @Override
    public void install(DockController dockController) {
        super.install(dockController);
        ActionViewConverter actionViewConverter = dockController.getActionViewConverter();
        actionViewConverter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.TITLE, new FlatPanelPopupGenerator());
        actionViewConverter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.MENU, new PanelMenuGenerator());
        actionViewConverter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.DROP_DOWN, new PanelDropDownGenerator());
    }

    @Override
    public void uninstall(DockController dockController) {
        ActionViewConverter actionViewConverter = dockController.getActionViewConverter();
        actionViewConverter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.TITLE, null);
        actionViewConverter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.MENU, null);
        actionViewConverter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.DROP_DOWN, null);
        super.uninstall(dockController);
    }
}

