/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CMaximizeBehavior;
import bibliothek.gui.dock.common.action.predefined.CMaximizeAction;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.KeyboardListener;
import bibliothek.gui.dock.facile.mode.AbstractLocationMode;
import bibliothek.gui.dock.facile.mode.DefaultLocationModeActionProvider;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeEvent;
import bibliothek.gui.dock.facile.mode.LocationModeListener;
import bibliothek.gui.dock.facile.mode.LocationModeManager;
import bibliothek.gui.dock.facile.mode.MaximizedModeArea;
import bibliothek.gui.dock.facile.mode.MaximizedModeSetting;
import bibliothek.gui.dock.facile.mode.NormalMode;
import bibliothek.gui.dock.facile.mode.action.MaximizedModeAction;
import bibliothek.gui.dock.support.mode.AffectedSet;
import bibliothek.gui.dock.support.mode.AffectingRunnable;
import bibliothek.gui.dock.support.mode.Mode;
import bibliothek.gui.dock.support.mode.ModeManager;
import bibliothek.gui.dock.support.mode.ModeManagerListener;
import bibliothek.gui.dock.support.mode.ModeSetting;
import bibliothek.gui.dock.support.mode.ModeSettingFactory;
import bibliothek.gui.dock.support.util.Resources;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.util.Path;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaximizedMode<M extends MaximizedModeArea>
extends AbstractLocationMode<M> {
    public static final Path IDENTIFIER = new Path("dock.mode.maximized");
    public static final String ICON_IDENTIFIER = "location.maximize";
    private CMaximizeBehavior maximizeBehavior = CMaximizeBehavior.STACKED;
    private HashMap<String, Path> lastMaximizedMode = new HashMap();
    private HashMap<String, Location> lastMaximizedLocation = new HashMap();
    private Listener listener = new Listener();
    private List<KeyHook> hooks = new LinkedList<KeyHook>();
    private PropertyValue<KeyStroke> keyStrokeMaximizeChange = new PropertyValue<KeyStroke>(CControl.KEY_MAXIMIZE_CHANGE){

        @Override
        protected void valueChanged(KeyStroke keyStroke, KeyStroke keyStroke2) {
        }
    };

    protected MaximizedMode() {
    }

    public MaximizedMode(CControl cControl) {
        this.setActionProvider(new DefaultLocationModeActionProvider(new CMaximizeAction(cControl)));
    }

    public MaximizedMode(DockController dockController) {
        IconManager iconManager = dockController.getIcons();
        iconManager.setIconDefault("maximize", Resources.getIcon("maximize"));
        this.setActionProvider(new DefaultLocationModeActionProvider(new MaximizedModeAction(dockController, this)));
    }

    @Override
    public void setManager(LocationModeManager<?> locationModeManager) {
        for (KeyHook keyHook : this.hooks) {
            keyHook.destroy(false);
        }
        this.hooks.clear();
        LocationModeManager<?> locationModeManager2 = this.getManager();
        this.listener.replaceManager(locationModeManager2, locationModeManager);
        if (locationModeManager == null) {
            this.keyStrokeMaximizeChange.setProperties((DockProperties)null);
        } else {
            this.keyStrokeMaximizeChange.setProperties(locationModeManager.getController());
        }
        super.setManager(locationModeManager);
    }

    public void setMaximizeBehavior(CMaximizeBehavior cMaximizeBehavior) {
        if (cMaximizeBehavior == null) {
            throw new IllegalArgumentException("maximizeBehavior must not be null");
        }
        this.maximizeBehavior = cMaximizeBehavior;
    }

    public CMaximizeBehavior getMaximizeBehavior() {
        return this.maximizeBehavior;
    }

    @Override
    public Path getUniqueIdentifier() {
        return IDENTIFIER;
    }

    @Override
    public ExtendedMode getExtendedMode() {
        return ExtendedMode.MAXIMIZED;
    }

    @Override
    public void runApply(Dockable dockable, Location location, AffectedSet affectedSet) {
        MaximizedModeArea maximizedModeArea = this.getMaximizeArea(dockable);
        if (maximizedModeArea == null) {
            maximizedModeArea = (MaximizedModeArea)this.getDefaultArea();
        }
        maximizedModeArea.prepareApply(dockable, location, affectedSet);
        this.maximize(maximizedModeArea, dockable, location, affectedSet);
    }

    @Override
    public Location current(Dockable dockable) {
        MaximizedModeArea maximizedModeArea = (MaximizedModeArea)this.get(dockable);
        if (maximizedModeArea == null) {
            return null;
        }
        return new Location(this.getUniqueIdentifier(), maximizedModeArea.getUniqueId(), null);
    }

    @Override
    public boolean isCurrentMode(Dockable dockable) {
        for (MaximizedModeArea maximizedModeArea : this) {
            if (!maximizedModeArea.isChild(dockable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDefaultMode(Dockable dockable) {
        return false;
    }

    public LocationMode getUnmaximizedMode(Dockable dockable) {
        while (dockable != null) {
            for (MaximizedModeArea maximizedModeArea : this) {
                if (!maximizedModeArea.isChild(dockable)) continue;
                return maximizedModeArea.getUnmaximizedMode();
            }
            DockStation dockStation = dockable.getDockParent();
            dockable = dockStation == null ? null : dockStation.asDockable();
        }
        return null;
    }

    public void maximize(MaximizedModeArea maximizedModeArea, Dockable dockable, AffectedSet affectedSet) {
        this.maximize(maximizedModeArea, dockable, null, affectedSet);
    }

    public void maximize(MaximizedModeArea maximizedModeArea, Dockable dockable, Location location, AffectedSet affectedSet) {
        Dockable dockable2 = this.getMaximizingElement(dockable);
        if (dockable2 != dockable) {
            this.getManager().store(dockable2);
        }
        if (maximizedModeArea == null) {
            maximizedModeArea = this.getMaximizeArea(dockable2);
        }
        if (maximizedModeArea == null) {
            maximizedModeArea = (MaximizedModeArea)this.getDefaultArea();
        }
        String string = this.getManager().getKey(dockable2);
        Mode mode = this.getManager().getCurrentMode(dockable);
        if (string == null && mode != null) {
            this.lastMaximizedLocation.put(maximizedModeArea.getUniqueId(), (Location)mode.current(dockable));
            this.lastMaximizedMode.put(maximizedModeArea.getUniqueId(), mode.getUniqueIdentifier());
        } else {
            this.lastMaximizedLocation.remove(maximizedModeArea.getUniqueId());
            this.lastMaximizedMode.remove(maximizedModeArea.getUniqueId());
            this.getManager().store(dockable);
        }
        maximizedModeArea.setMaximized(dockable2, true, location, affectedSet);
        affectedSet.add(dockable2);
    }

    public void unmaximize(Dockable dockable, AffectedSet affectedSet) {
        Dockable[] dockableArray;
        final MaximizedModeArea maximizedModeArea = this.getMaximizeArea(dockable);
        if (maximizedModeArea != null && maximizedModeArea.getMaximized() != null && (dockableArray = maximizedModeArea.getMaximized()) != null) {
            for (Dockable dockable2 : dockableArray) {
                if (!DockUtilities.isAncestor(dockable2, dockable)) continue;
                affectedSet.add(dockable);
                final Dockable dockable3 = dockable = dockable2;
                final LocationModeManager<?> locationModeManager = this.getManager();
                locationModeManager.runTransaction(new AffectingRunnable(){

                    public void run(AffectedSet affectedSet) {
                        boolean bl = locationModeManager.isRegistered(dockable3);
                        maximizedModeArea.setMaximized(dockable3, false, null, affectedSet);
                        String string = maximizedModeArea.getUniqueId();
                        boolean bl2 = false;
                        if (MaximizedMode.this.lastMaximizedLocation.get(string) != null) {
                            bl2 = true;
                            bl2 = MaximizedMode.this.getManager().apply(dockable3, (Path)MaximizedMode.this.lastMaximizedMode.remove(string), MaximizedMode.this.lastMaximizedLocation.remove(string), affectedSet);
                        }
                        if (bl && !bl2) {
                            LocationMode locationMode = (LocationMode)locationModeManager.getPreviousMode(dockable3);
                            if (locationMode == null || locationMode == MaximizedMode.this) {
                                locationMode = (LocationMode)locationModeManager.getMode(NormalMode.IDENTIFIER);
                            }
                            locationModeManager.apply(dockable3, locationMode.getUniqueIdentifier(), affectedSet, true);
                        }
                    }
                }, true);
                locationModeManager.store(dockable);
                return;
            }
        }
    }

    public MaximizedModeArea getNextMaximizeArea(DockStation dockStation) {
        while (dockStation != null) {
            MaximizedModeArea maximizedModeArea = this.getMaximizeArea(dockStation);
            if (maximizedModeArea != null) {
                return maximizedModeArea;
            }
            Dockable dockable = dockStation.asDockable();
            if (dockable == null) {
                return null;
            }
            dockStation = dockable.getDockParent();
        }
        return null;
    }

    public void unmaximize(DockStation dockStation, AffectedSet affectedSet) {
        Dockable[] dockableArray;
        MaximizedModeArea maximizedModeArea = this.getNextMaximizeArea(dockStation);
        if (maximizedModeArea != null && (dockableArray = maximizedModeArea.getMaximized()) != null) {
            for (Dockable dockable : dockableArray) {
                this.unmaximize(dockable, affectedSet);
            }
        }
    }

    public void unmaximize(MaximizedModeArea maximizedModeArea, AffectedSet affectedSet) {
        Dockable[] dockableArray = maximizedModeArea.getMaximized();
        if (dockableArray != null) {
            for (Dockable dockable : dockableArray) {
                this.unmaximize(dockable, affectedSet);
            }
        }
    }

    @Override
    public void ensureNotHidden(final Dockable dockable) {
        this.getManager().runTransaction(new AffectingRunnable(){

            public void run(AffectedSet affectedSet) {
                Dockable dockable4 = dockable;
                DockStation dockStation = dockable4.getDockParent();
                Dockable dockable2 = MaximizedMode.this.getMaximizingElement(dockable4);
                while (dockStation != null) {
                    Dockable[] dockableArray;
                    MaximizedModeArea maximizedModeArea = MaximizedMode.this.getMaximizeArea(dockStation);
                    if (maximizedModeArea != null && (dockableArray = maximizedModeArea.getMaximized()) != null) {
                        for (Dockable dockable3 : dockableArray) {
                            if (dockableArray == null || dockable3 == dockable4 || dockable3 == dockable2) continue;
                            MaximizedMode.this.unmaximize(dockable3, affectedSet);
                        }
                    }
                    dockStation = (dockable4 = dockStation.asDockable()) == null ? null : dockable4.getDockParent();
                }
            }
        });
    }

    public MaximizedModeArea getMaximizeArea(Dockable dockable) {
        DockStation dockStation = dockable.getDockParent();
        while (dockStation != null) {
            MaximizedModeArea maximizedModeArea = this.getMaximizeArea(dockStation);
            if (maximizedModeArea != null) {
                return maximizedModeArea;
            }
            dockable = dockStation.asDockable();
            if (dockable == null) {
                dockStation = null;
                continue;
            }
            dockStation = dockable.getDockParent();
        }
        return null;
    }

    public MaximizedModeArea getMaximizeArea(DockStation dockStation) {
        for (MaximizedModeArea maximizedModeArea : this) {
            if (!maximizedModeArea.isRepresenting(dockStation)) continue;
            return maximizedModeArea;
        }
        return null;
    }

    public Dockable getMaximizingElement(Dockable dockable) {
        return this.maximizeBehavior.getMaximizingElement(dockable);
    }

    public Dockable getMaximizingElement(Dockable dockable, Dockable dockable2) {
        return this.maximizeBehavior.getMaximizingElement(dockable, dockable2);
    }

    protected void applyStarting(LocationModeEvent locationModeEvent) {
        Runnable runnable;
        Dockable[] dockableArray;
        MaximizedModeArea maximizedModeArea2;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (MaximizedModeArea maximizedModeArea2 : this) {
            dockableArray = maximizedModeArea2.onApply(locationModeEvent);
            if (dockableArray == null) continue;
            arrayList.add(dockableArray);
        }
        Dockable dockable = locationModeEvent.getDockable();
        maximizedModeArea2 = this.getMaximizeArea(dockable);
        if (maximizedModeArea2 == null) {
            return;
        }
        dockableArray = maximizedModeArea2.getMaximized();
        if (dockableArray == null) {
            return;
        }
        Dockable dockable2 = null;
        for (int i = 0; i < dockableArray.length; ++i) {
            if (!DockUtilities.isAncestor(dockableArray[i], dockable)) continue;
            dockable2 = this.getMaximizingElement(dockableArray[i], dockable);
            break;
        }
        if ((runnable = maximizedModeArea2.onApply(locationModeEvent, dockable2)) != null) {
            arrayList.add(runnable);
        }
        if (!arrayList.isEmpty()) {
            locationModeEvent.setClientObject(this.listener, arrayList);
        }
    }

    protected void applyDone(LocationModeEvent locationModeEvent) {
        List list = (List)locationModeEvent.getClientObject(this.listener);
        if (list != null) {
            for (Runnable runnable : list) {
                runnable.run();
            }
        }
    }

    @Override
    public ModeSettingFactory<Location> getSettingFactory() {
        return MaximizedModeSetting.FACTORY;
    }

    @Override
    public void writeSetting(ModeSetting<Location> modeSetting) {
        if (modeSetting instanceof MaximizedModeSetting) {
            MaximizedModeSetting maximizedModeSetting = (MaximizedModeSetting)modeSetting;
            maximizedModeSetting.setLastMaximizedLocation(this.lastMaximizedLocation);
            maximizedModeSetting.setLastMaximizedMode(this.lastMaximizedMode);
        }
    }

    @Override
    public void readSetting(ModeSetting<Location> modeSetting) {
        if (modeSetting instanceof MaximizedModeSetting) {
            MaximizedModeSetting maximizedModeSetting = (MaximizedModeSetting)modeSetting;
            this.lastMaximizedLocation = new HashMap<String, Location>(maximizedModeSetting.getLastMaximizedLocation());
            this.lastMaximizedMode = new HashMap<String, Path>(maximizedModeSetting.getLastMaximizedMode());
        }
    }

    protected boolean process(Dockable dockable, KeyEvent keyEvent) {
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        if (keyStroke.equals(this.keyStrokeMaximizeChange.getValue())) {
            return this.switchMode(dockable);
        }
        return false;
    }

    public boolean switchMode(Dockable dockable) {
        LocationModeManager<?> locationModeManager = this.getManager();
        Mode mode = locationModeManager.getCurrentMode(dockable);
        if (mode == this) {
            LocationMode locationMode = (LocationMode)locationModeManager.getPreviousMode(dockable);
            if (locationMode != null && locationModeManager.isModeAvailable(dockable, locationMode.getExtendedMode())) {
                locationModeManager.apply(dockable, locationMode.getUniqueIdentifier(), false);
                locationModeManager.ensureValidLocation(dockable);
                return true;
            }
        } else if (locationModeManager.isModeAvailable(dockable, this.getExtendedMode())) {
            locationModeManager.apply(dockable, this.getUniqueIdentifier(), false);
            locationModeManager.ensureValidLocation(dockable);
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Listener
    implements ModeManagerListener<Location, LocationMode>,
    LocationModeListener {
        private Listener() {
        }

        public void replaceManager(LocationModeManager<?> locationModeManager, LocationModeManager<?> locationModeManager2) {
            if (locationModeManager != null) {
                locationModeManager.removeModeManagerListener(this);
                for (LocationMode object : locationModeManager.modes()) {
                    this.modeRemoved((ModeManager<? extends Location, ? extends LocationMode>)locationModeManager, object);
                }
            }
            if (locationModeManager2 != null) {
                locationModeManager2.addModeManagerListener(this);
                for (LocationMode locationMode : locationModeManager2.modes()) {
                    this.modeAdded((ModeManager<? extends Location, ? extends LocationMode>)locationModeManager2, locationMode);
                }
                for (Dockable dockable : locationModeManager2.listDockables()) {
                    new KeyHook(dockable);
                }
            }
        }

        @Override
        public void dockableAdded(ModeManager<? extends Location, ? extends LocationMode> modeManager, Dockable dockable) {
            new KeyHook(dockable);
        }

        @Override
        public void dockableRemoved(ModeManager<? extends Location, ? extends LocationMode> modeManager, Dockable dockable) {
        }

        @Override
        public void modeAdded(ModeManager<? extends Location, ? extends LocationMode> modeManager, LocationMode locationMode) {
            if (locationMode != MaximizedMode.this) {
                locationMode.addLocationModeListener(this);
            }
        }

        @Override
        public void modeChanged(ModeManager<? extends Location, ? extends LocationMode> modeManager, Dockable dockable, LocationMode locationMode, LocationMode locationMode2) {
        }

        @Override
        public void modeRemoved(ModeManager<? extends Location, ? extends LocationMode> modeManager, LocationMode locationMode) {
            locationMode.removeLocationModeListener(this);
        }

        @Override
        public void applyDone(LocationModeEvent locationModeEvent) {
            MaximizedMode.this.applyDone(locationModeEvent);
        }

        @Override
        public void applyStarting(LocationModeEvent locationModeEvent) {
            MaximizedMode.this.applyStarting(locationModeEvent);
        }
    }

    private class KeyHook
    extends DockRegisterAdapter
    implements KeyboardListener {
        private Dockable dockable;
        private DockController controller;

        public KeyHook(Dockable dockable) {
            this.dockable = dockable;
            this.controller = MaximizedMode.this.getController();
            this.controller.getKeyboardController().addListener(this);
            this.controller.getRegister().addDockRegisterListener(this);
            MaximizedMode.this.hooks.add(this);
        }

        public void dockableUnregistered(DockController dockController, Dockable dockable) {
            if (this.dockable == dockable) {
                this.destroy(true);
            }
        }

        public void destroy(boolean bl) {
            this.controller.getKeyboardController().removeListener(this);
            this.controller.getRegister().removeDockRegisterListener(this);
            if (bl) {
                MaximizedMode.this.hooks.remove(this);
            }
        }

        public DockElement getTreeLocation() {
            return this.dockable;
        }

        public boolean keyPressed(DockElement dockElement, KeyEvent keyEvent) {
            return MaximizedMode.this.process(this.dockable, keyEvent);
        }

        public boolean keyReleased(DockElement dockElement, KeyEvent keyEvent) {
            return MaximizedMode.this.process(this.dockable, keyEvent);
        }

        public boolean keyTyped(DockElement dockElement, KeyEvent keyEvent) {
            return MaximizedMode.this.process(this.dockable, keyEvent);
        }
    }
}

