/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock;

import bibliothek.extension.gui.dock.preference.PreferenceEditor;
import bibliothek.extension.gui.dock.preference.PreferenceEditorCallback;
import bibliothek.extension.gui.dock.preference.PreferenceEditorFactory;
import bibliothek.extension.gui.dock.preference.PreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceModelListener;
import bibliothek.extension.gui.dock.preference.PreferenceOperation;
import bibliothek.extension.gui.dock.preference.editor.BooleanEditor;
import bibliothek.extension.gui.dock.preference.editor.ChoiceEditor;
import bibliothek.extension.gui.dock.preference.editor.KeyStrokeEditor;
import bibliothek.extension.gui.dock.preference.editor.LabelEditor;
import bibliothek.extension.gui.dock.preference.editor.ModifierMaskEditor;
import bibliothek.extension.gui.dock.preference.editor.StringEditor;
import bibliothek.gui.dock.themes.basic.action.BasicButtonModel;
import bibliothek.gui.dock.themes.basic.action.BasicTrigger;
import bibliothek.gui.dock.themes.basic.action.buttons.BasicMiniButton;
import bibliothek.util.Path;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferenceTable
extends JPanel {
    private Map<Path, PreferenceEditorFactory<?>> factories = new HashMap();
    private PreferenceModel model;
    private List<Row<?>> rows = new ArrayList();
    private JPanel panel;
    private GridBagLayout layout;
    private Listener listener = new Listener();
    private List<PreferenceOperation> operations = new ArrayList<PreferenceOperation>();
    private boolean reverseOrder = true;

    public PreferenceTable() {
        super(new GridBagLayout());
        this.layout = new GridBagLayout();
        this.panel = new JPanel(this.layout);
        this.add((Component)this.panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setEditorFactory(Path.TYPE_BOOLEAN_PATH, BooleanEditor.FACTORY);
        this.setEditorFactory(Path.TYPE_MODIFIER_MASK_PATH, ModifierMaskEditor.FACTORY);
        this.setEditorFactory(Path.TYPE_KEYSTROKE_PATH, KeyStrokeEditor.FACTORY);
        this.setEditorFactory(Path.TYPE_STRING_CHOICE_PATH, ChoiceEditor.FACTORY);
        this.setEditorFactory(Path.TYPE_LABEL, LabelEditor.FACTORY);
        this.setEditorFactory(Path.TYPE_STRING_PATH, StringEditor.FACTORY);
        this.operations.add(PreferenceOperation.DEFAULT);
        this.operations.add(PreferenceOperation.DELETE);
    }

    public void setReverseOrder(boolean bl) {
        this.reverseOrder = bl;
        int n = 0;
        for (Row<?> row : this.rows) {
            row.setIndex(n++);
        }
    }

    public boolean isReverseOrder() {
        return this.reverseOrder;
    }

    public void addOperation(PreferenceOperation preferenceOperation) {
        if (!this.operations.contains(preferenceOperation)) {
            this.operations.add(preferenceOperation);
        }
    }

    public void insertOperation(int n, PreferenceOperation preferenceOperation) {
        if (!this.operations.contains(preferenceOperation)) {
            this.operations.add(n, preferenceOperation);
        }
    }

    private int getOperationIndex(PreferenceOperation preferenceOperation) {
        int n = this.operations.indexOf(preferenceOperation);
        if (n < 0) {
            this.operations.add(preferenceOperation);
            n = this.operations.size() - 1;
        }
        if (this.reverseOrder) {
            n = this.operations.size() - 1 - n;
        }
        return n;
    }

    private void addTable(Component component) {
        this.panel.add(component);
    }

    private void removeTable(Component component) {
        this.panel.remove(component);
    }

    public PreferenceTable(PreferenceModel preferenceModel) {
        this();
        this.setModel(preferenceModel);
    }

    public PreferenceModel getModel() {
        return this.model;
    }

    public void setModel(PreferenceModel preferenceModel) {
        if (this.model != null) {
            this.model.removePreferenceModelListener(this.listener);
            this.listener.preferenceRemoved(this.model, 0, this.model.getSize() - 1);
        }
        this.model = preferenceModel;
        if (this.model != null) {
            this.model.addPreferenceModelListener(this.listener);
            this.listener.preferenceAdded(this.model, 0, this.model.getSize() - 1);
        }
    }

    public void setEditorFactory(Path path, PreferenceEditorFactory<?> preferenceEditorFactory) {
        if (preferenceEditorFactory == null) {
            this.factories.remove(path);
        } else {
            this.factories.put(path, preferenceEditorFactory);
        }
    }

    public <V> PreferenceEditorFactory<V> getEditorFactory(Path path) {
        return this.factories.get(path);
    }

    protected <V> PreferenceEditor<V> createEditor(Path path) {
        PreferenceEditorFactory<?> preferenceEditorFactory = this.factories.get(path);
        if (preferenceEditorFactory == null) {
            throw new IllegalArgumentException("No editor defined for type '" + path.toString() + "'");
        }
        return preferenceEditorFactory.create();
    }

    private class Listener
    implements PreferenceModelListener {
        private Listener() {
        }

        public void preferenceAdded(PreferenceModel preferenceModel, int n, int n2) {
            int n3;
            for (n3 = n; n3 <= n2; ++n3) {
                PreferenceEditor preferenceEditor = PreferenceTable.this.createEditor(preferenceModel.getTypePath(n3));
                Row row = new Row(preferenceEditor, preferenceModel.getLabel(n3), preferenceModel.getDescription(n3));
                PreferenceTable.this.rows.add(n3, row);
                row.setIndex(n3);
            }
            int n4 = PreferenceTable.this.rows.size();
            for (n3 = n; n3 < n4; ++n3) {
                ((Row)PreferenceTable.this.rows.get(n3)).setIndex(n3);
            }
            PreferenceTable.this.revalidate();
        }

        public void preferenceChanged(PreferenceModel preferenceModel, int n, int n2) {
            for (int i = n; i <= n2; ++i) {
                Row row = (Row)PreferenceTable.this.rows.get(i);
                row.changed();
            }
            PreferenceTable.this.revalidate();
        }

        public void preferenceRemoved(PreferenceModel preferenceModel, int n, int n2) {
            int n3;
            for (n3 = n2; n3 >= n; --n3) {
                Row row = (Row)PreferenceTable.this.rows.remove(n3);
                row.kill();
            }
            int n4 = PreferenceTable.this.rows.size();
            for (n3 = n; n3 < n4; ++n3) {
                ((Row)PreferenceTable.this.rows.get(n3)).setIndex(n3);
            }
            PreferenceTable.this.revalidate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Row<V>
    implements PreferenceEditorCallback<V> {
        private int index;
        private JLabel label;
        private PreferenceEditor<V> editor;
        private Map<PreferenceOperation, Button> editorOperations;
        private Map<PreferenceOperation, Button> modelOperations;
        private boolean initialized = false;

        public Row(PreferenceEditor<V> preferenceEditor, String string, String string2) {
            this.editor = preferenceEditor;
            this.label = new JLabel(string);
            this.label.setToolTipText(string2);
            PreferenceTable.this.addTable(this.label);
            if (preferenceEditor != null) {
                preferenceEditor.setCallback(this);
            }
            PreferenceTable.this.addTable(preferenceEditor.getComponent());
        }

        public void setIndex(int n) {
            int n2;
            this.index = n;
            PreferenceTable.this.layout.setConstraints(this.label, new GridBagConstraints(0, n, 1, 1, 1.0, 1.0, 21, 0, new Insets(1, 1, 1, 1), 0, 0));
            if (this.editor != null) {
                PreferenceTable.this.layout.setConstraints(this.editor.getComponent(), new GridBagConstraints(1, n, 1, 1, 100.0, 1.0, 21, 2, new Insets(1, 1, 1, 1), 0, 0));
            }
            if (!this.initialized) {
                this.initialized = true;
                this.initialize();
            }
            if (this.modelOperations != null) {
                for (Map.Entry<PreferenceOperation, Button> entry : this.modelOperations.entrySet()) {
                    n2 = 2 + PreferenceTable.this.getOperationIndex(entry.getKey());
                    PreferenceTable.this.layout.setConstraints(entry.getValue(), new GridBagConstraints(n2, n, 1, 1, 1.0, 1.0, 22, 0, new Insets(1, 0, 1, 0), 0, 0));
                }
            }
            if (this.editorOperations != null) {
                for (Map.Entry<PreferenceOperation, Button> entry : this.editorOperations.entrySet()) {
                    n2 = 2 + PreferenceTable.this.getOperationIndex(entry.getKey());
                    PreferenceTable.this.layout.setConstraints(entry.getValue(), new GridBagConstraints(n2, n, 1, 1, 1.0, 1.0, 22, 0, new Insets(1, 0, 1, 0), 0, 0));
                }
            }
            PreferenceTable.this.revalidate();
        }

        @Override
        public void setOperation(PreferenceOperation preferenceOperation, boolean bl) {
            this.setOperation(preferenceOperation, bl, true);
        }

        private void initialize() {
            PreferenceOperation[] preferenceOperationArray = PreferenceTable.this.model.getOperations(this.index);
            if (preferenceOperationArray != null) {
                for (PreferenceOperation preferenceOperation : preferenceOperationArray) {
                    if (this.editorOperations != null && this.editorOperations.containsKey(preferenceOperation)) continue;
                    this.setOperation(preferenceOperation, PreferenceTable.this.model.isEnabled(this.index, preferenceOperation), false);
                }
            }
            if (this.editor != null) {
                this.editor.setValueInfo(PreferenceTable.this.model.getValueInfo(this.index));
                this.editor.setValue(PreferenceTable.this.model.getValue(this.index));
            }
        }

        private void setOperation(PreferenceOperation preferenceOperation, boolean bl, boolean bl2) {
            Map<PreferenceOperation, Button> map;
            if (bl2) {
                if (this.editorOperations == null) {
                    this.editorOperations = new HashMap<PreferenceOperation, Button>();
                }
                map = this.editorOperations;
            } else {
                if (this.modelOperations == null) {
                    this.modelOperations = new HashMap<PreferenceOperation, Button>();
                }
                map = this.modelOperations;
            }
            Button button = map.get(preferenceOperation);
            if (button == null) {
                button = new Button(preferenceOperation, bl2);
                map.put(preferenceOperation, button);
                PreferenceTable.this.addTable(button);
                int n = 2 + PreferenceTable.this.getOperationIndex(preferenceOperation);
                PreferenceTable.this.layout.setConstraints(button, new GridBagConstraints(n, this.index, 1, 1, 1.0, 1.0, 22, 0, new Insets(1, 0, 1, 0), 0, 0));
                PreferenceTable.this.revalidate();
            }
            ((BasicButtonModel)button.getModel()).setEnabled(bl);
        }

        public void changed() {
            if (this.editor != null) {
                this.editor.setValue(PreferenceTable.this.model.getValue(this.index));
            }
            if (this.modelOperations != null) {
                for (Map.Entry<PreferenceOperation, Button> entry : this.modelOperations.entrySet()) {
                    boolean bl = PreferenceTable.this.model.isEnabled(this.index, entry.getKey());
                    ((BasicButtonModel)entry.getValue().getModel()).setEnabled(bl);
                }
            }
        }

        public void kill() {
            PreferenceTable.this.removeTable(this.label);
            if (this.editor != null) {
                this.editor.setCallback(null);
                this.editor.setValue(null);
                PreferenceTable.this.removeTable(this.editor.getComponent());
                this.editor.setValueInfo(null);
            }
            if (this.editorOperations != null) {
                for (Button button : this.editorOperations.values()) {
                    PreferenceTable.this.removeTable(button);
                }
            }
            if (this.modelOperations != null) {
                for (Button button : this.modelOperations.values()) {
                    PreferenceTable.this.removeTable(button);
                }
            }
        }

        @Override
        public V get() {
            return (V)PreferenceTable.this.model.getValue(this.index);
        }

        @Override
        public void set(V v) {
            PreferenceTable.this.model.setValue(this.index, v);
        }

        private void doOperation(PreferenceOperation preferenceOperation) {
            PreferenceTable.this.model.doOperation(this.index, preferenceOperation);
        }

        private class Button
        extends BasicMiniButton {
            public Button(final PreferenceOperation preferenceOperation, final boolean bl) {
                super(new BasicTrigger(){

                    public void triggered() {
                        if (bl) {
                            Row.this.editor.doOperation(preferenceOperation);
                        } else {
                            Row.this.doOperation(preferenceOperation);
                        }
                    }
                });
                ((BasicButtonModel)this.getModel()).setIcon(preferenceOperation.getIcon());
                ((BasicButtonModel)this.getModel()).setToolTipText(preferenceOperation.getDescription());
                this.setMouseOverBorder(BorderFactory.createEtchedBorder(1));
                this.setMousePressedBorder(BorderFactory.createLoweredBevelBorder());
            }

            public void setEnabled(boolean bl) {
                super.setEnabled(bl);
                this.setFocusable(bl);
            }
        }
    }
}

