/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack.tab;

import bibliothek.extension.gui.dock.theme.eclipse.OwnedEclipseBorder;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.Arch;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.BaseTabComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.BorderedComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.DefaultInvisibleTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.InvisibleTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.InvisibleTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.LinePainter;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabComponent;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabPainter;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabPanePainter;
import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.util.Colors;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

public class ArchGradientPainter
extends BaseTabComponent {
    private final int[] TOP_LEFT_CORNER_X = new int[]{0, 1, 1, 2, 3, 4, 5, 6};
    private final int[] TOP_LEFT_CORNER_Y = new int[]{6, 5, 4, 3, 2, 1, 1, 0};
    private Arch arch;
    private boolean wasPreviousSelected = false;
    public static final TabPainter FACTORY = new TabPainter(){

        public TabComponent createTabComponent(EclipseTabPane eclipseTabPane, Dockable dockable) {
            return new ArchGradientPainter(eclipseTabPane, dockable);
        }

        public TabPanePainter createDecorationPainter(EclipseTabPane eclipseTabPane) {
            return new LinePainter(eclipseTabPane);
        }

        public InvisibleTab createInvisibleTab(InvisibleTabPane invisibleTabPane, Dockable dockable) {
            return new DefaultInvisibleTab(invisibleTabPane, dockable);
        }

        public Border getFullBorder(BorderedComponent borderedComponent, DockController dockController, Dockable dockable) {
            return new OwnedEclipseBorder(borderedComponent, dockController, true);
        }
    };
    private final int TAB_OVERLAP = 24;

    public ArchGradientPainter(EclipseTabPane eclipseTabPane, Dockable dockable) {
        super(eclipseTabPane, dockable);
        this.setLayout(null);
        this.setOpaque(false);
        this.update();
        this.updateFont();
        this.updateBorder();
    }

    public void updateBorder() {
        EclipseTabPane eclipseTabPane = this.getPane();
        int n = this.getDockableIndex();
        if (this.isBound() && eclipseTabPane != null && n >= 0) {
            Window window = SwingUtilities.getWindowAncestor(this.getComponent());
            boolean bl = false;
            if (window != null) {
                boolean bl2 = bl = !window.isActive();
            }
            Color color = this.isSelected() ? (this.isFocused() ? (bl ? (Color)this.colorStackTabBorderSelectedFocusLost.value() : (Color)this.colorStackTabBorderSelectedFocused.value()) : (Color)this.colorStackTabBorderSelected.value()) : (Color)this.colorStackTabBorder.value();
            eclipseTabPane.setContentBorderAt(n, new MatteBorder(2, 2, 2, 2, color));
        }
    }

    public Insets getOverlap(TabComponent tabComponent) {
        ArchGradientPainter archGradientPainter;
        if (tabComponent instanceof ArchGradientPainter && (archGradientPainter = (ArchGradientPainter)tabComponent).isSelected()) {
            if (this.getOrientation().isHorizontal()) {
                return new Insets(0, 34, 0, 0);
            }
            return new Insets(34, 0, 0, 0);
        }
        return new Insets(0, 0, 0, 0);
    }

    public Dimension getPreferredSize() {
        boolean bl = this.isPreviousTabSelected();
        if (this.wasPreviousSelected != bl) {
            this.wasPreviousSelected = bl;
            this.update();
        }
        return super.getPreferredSize();
    }

    public void updateFocus() {
        this.update();
        this.updateBorder();
        this.updateFont();
    }

    protected void updateOrientation() {
        this.update();
    }

    protected void updateSelected() {
        this.update();
        this.updateBorder();
        this.updateFont();
    }

    protected void updateColors() {
        this.update();
    }

    protected void update() {
        Insets insets = null;
        Insets insets2 = null;
        switch (this.getOrientation()) {
            case TOP_OF_DOCKABLE: 
            case BOTTOM_OF_DOCKABLE: {
                insets = new Insets(3, 5, 3, 2);
                insets2 = new Insets(1, 0, 1, 5);
                break;
            }
            case LEFT_OF_DOCKABLE: 
            case RIGHT_OF_DOCKABLE: {
                insets = new Insets(5, 3, 2, 3);
                insets2 = new Insets(0, 1, 5, 1);
            }
        }
        boolean bl = this.getOrientation().isHorizontal();
        if (this.isSelected()) {
            if (bl) {
                insets2.right += 35;
            } else {
                insets2.bottom += 35;
            }
        }
        if (this.isPreviousTabSelected()) {
            if (bl) {
                insets.left += 24;
            } else {
                insets.top += 24;
            }
        }
        this.getLabel().setForeground(this.getTextColor());
        this.setLabelInsets(insets);
        this.setButtonInsets(insets2);
        this.revalidate();
        this.repaint();
    }

    private Arch arch(int n, int n2) {
        if (this.arch == null || this.arch.getWidth() != n || this.arch.getHeight() != n2) {
            this.arch = new Arch(n, n2);
        }
        return this.arch;
    }

    private Color getTextColor() {
        boolean bl = this.isFocusTemporarilyLost();
        if (this.isFocused() && !bl) {
            return (Color)this.colorStackTabTextSelectedFocused.value();
        }
        if (this.isFocused() && bl) {
            return (Color)this.colorStackTabTextSelectedFocusLost.value();
        }
        if (this.isSelected()) {
            return (Color)this.colorStackTabTextSelected.value();
        }
        return (Color)this.colorStackTabText.value();
    }

    protected void paintComponent(Graphics graphics) {
        Color color;
        Color color2;
        super.paintComponent(graphics);
        int n = 0;
        int n2 = 0;
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color3 = (Color)this.colorStackBorder.value();
        boolean bl = this.isFocusTemporarilyLost();
        if (this.isFocused() && !bl) {
            color2 = (Color)this.colorStackTabTopSelectedFocused.value();
            color = (Color)this.colorStackTabBottomSelectedFocused.value();
        } else if (this.isFocused() && bl) {
            color2 = (Color)this.colorStackTabTopSelectedFocusLost.value();
            color = (Color)this.colorStackTabBottomSelectedFocusLost.value();
        } else if (this.isSelected()) {
            color2 = (Color)this.colorStackTabTopSelected.value();
            color = (Color)this.colorStackTabBottomSelected.value();
        } else {
            color2 = (Color)this.colorStackTabTop.value();
            color = (Color)this.colorStackTabBottom.value();
        }
        if (this.isSelected()) {
            switch (this.getOrientation()) {
                case TOP_OF_DOCKABLE: 
                case LEFT_OF_DOCKABLE: {
                    this.paintSelected(graphics2D, color2, color);
                    break;
                }
                case BOTTOM_OF_DOCKABLE: 
                case RIGHT_OF_DOCKABLE: {
                    this.paintSelected(graphics2D, color, color2);
                }
            }
        } else {
            GradientPaint gradientPaint = color2.equals(color) ? null : new GradientPaint(n, n2, color2, n, n2 + n4, color);
            Paint paint = graphics2D.getPaint();
            if (gradientPaint != null) {
                graphics2D.setPaint(gradientPaint);
            } else {
                graphics2D.setPaint(color2);
            }
            graphics2D.fillRect(n, n2, n3, n4 - 1);
            graphics2D.setPaint(paint);
        }
        if (!this.isSelected() && !this.isNextTabSelected()) {
            graphics.setColor(color3);
            if (this.getOrientation().isHorizontal()) {
                graphics.drawLine(n3 - 1, 0, n3 - 1, n4);
            } else {
                graphics.drawLine(0, n4 - 1, n3, n4 - 1);
            }
        }
    }

    public boolean contains(int n, int n2) {
        if (!super.contains(n, n2)) {
            return false;
        }
        if (this.isSelected()) {
            int n3;
            int n4 = this.getWidth();
            Polygon polygon = this.leftSide(0, 0, n4, n3 = this.getHeight());
            if (polygon.contains(n, n2)) {
                return true;
            }
            Polygon polygon2 = this.rightSide(0, 0, n4, n3);
            if (polygon2.contains(n, n2)) {
                return true;
            }
            Rectangle rectangle = polygon.getBounds();
            Rectangle rectangle2 = polygon2.getBounds();
            if (this.getOrientation().isHorizontal()) {
                if (rectangle.x + rectangle.width > n) {
                    return false;
                }
                if (rectangle2.x < n) {
                    return false;
                }
            } else {
                if (rectangle.y + rectangle.height > n2) {
                    return false;
                }
                if (rectangle2.y < n2) {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    private void paintSelected(Graphics graphics, Color color, Color color2) {
        int n = 0;
        int n2 = 0;
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color3 = (Color)this.colorStackBorder.value();
        boolean bl = this.getTabIndex() == 0;
        TabPlacement tabPlacement = this.getOrientation();
        Polygon polygon = tabPlacement.isHorizontal() ? this.leftSide(n - 1, n2 - 1, n3, n4 + 1) : this.leftSide(n - 1, n2 - 1, n3 + 1, n4);
        Polygon polygon2 = this.rightSide(n, n2, n3, n4);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (bl) {
            if (tabPlacement.isHorizontal()) {
                polygon.translate(-1, 0);
            } else {
                polygon.translate(0, -1);
            }
        }
        graphics.setColor(Colors.between(color3, this.getBackground(), 0.75));
        graphics.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints - 1);
        graphics.drawPolyline(polygon2.xpoints, polygon2.ypoints, polygon2.npoints - 1);
        GradientPaint gradientPaint = null;
        if (!color.equals(color2)) {
            gradientPaint = this.getOrientation().isHorizontal() ? new GradientPaint(n, n2, color, n, n2 + n4, color2) : new GradientPaint(n, n2, color, n + n3, n2, color2);
        }
        Paint paint = graphics2D.getPaint();
        if (gradientPaint != null) {
            graphics2D.setPaint(gradientPaint);
        } else {
            graphics2D.setPaint(color);
        }
        if (tabPlacement.isHorizontal()) {
            polygon.translate(1, 0);
            polygon2.translate(-1, 0);
        } else {
            polygon.translate(0, 1);
            polygon2.translate(0, -1);
        }
        graphics.fillPolygon(polygon);
        polygon2.translate(1, 1);
        graphics.fillPolygon(polygon2);
        polygon2.translate(-1, -1);
        switch (this.getOrientation()) {
            case TOP_OF_DOCKABLE: {
                graphics.drawLine(0, n4 - 1, n3 - 1, n4 - 1);
                break;
            }
            case BOTTOM_OF_DOCKABLE: {
                graphics.drawLine(0, 0, n3 - 1, 0);
                break;
            }
            case LEFT_OF_DOCKABLE: {
                graphics.drawLine(n3 - 1, 0, n3 - 1, n4 - 1);
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                graphics.drawLine(0, 0, 0, n4 - 1);
            }
        }
        Rectangle rectangle = polygon.getBounds();
        Rectangle rectangle2 = polygon2.getBounds();
        if (tabPlacement.isHorizontal()) {
            if (rectangle.x + rectangle.width < rectangle2.x) {
                graphics.fillRect(rectangle.x + rectangle.width, 0, rectangle2.x - rectangle.x - rectangle.width + 1, n4);
            }
        } else if (rectangle.y + rectangle.height < rectangle2.y) {
            graphics.fillRect(0, rectangle.y + rectangle.height, n3, rectangle2.y - rectangle.y - rectangle.height + 1);
        }
        graphics2D.setPaint(paint);
        graphics.setColor(color3);
        graphics.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints - 1);
        graphics.drawPolyline(polygon2.xpoints, polygon2.ypoints, polygon2.npoints - 1);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
    }

    private void mirror(int[] nArray) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        for (int n3 : nArray) {
            n = Math.min(n, n3);
            n2 = Math.max(n2, n3);
        }
        int n4 = nArray.length;
        for (int i = 0; i < n4; ++i) {
            nArray[i] = n2 - (nArray[i] - n);
        }
    }

    private void transformFromTopToOrientation(Polygon polygon) {
        switch (this.getOrientation()) {
            case BOTTOM_OF_DOCKABLE: {
                this.mirror(polygon.ypoints);
                break;
            }
            case RIGHT_OF_DOCKABLE: {
                this.mirror(polygon.ypoints);
            }
            case LEFT_OF_DOCKABLE: {
                int[] nArray = polygon.xpoints;
                polygon.xpoints = polygon.ypoints;
                polygon.ypoints = nArray;
            }
        }
    }

    private Polygon leftSide(int n, int n2, int n3, int n4) {
        if (this.getOrientation().isVertical()) {
            int n5 = n;
            n = n2;
            n2 = n5;
            n5 = n3;
            n3 = n4;
            n4 = n5;
        }
        Polygon polygon = this.leftSideTop(n, n2, n3, n4);
        this.transformFromTopToOrientation(polygon);
        return polygon;
    }

    private Polygon leftSideTop(int n, int n2, int n3, int n4) {
        int[] nArray = new int[this.TOP_LEFT_CORNER_X.length + 2];
        int[] nArray2 = new int[this.TOP_LEFT_CORNER_Y.length + 2];
        System.arraycopy(this.TOP_LEFT_CORNER_X, 0, nArray, 1, this.TOP_LEFT_CORNER_X.length);
        System.arraycopy(this.TOP_LEFT_CORNER_Y, 0, nArray2, 1, this.TOP_LEFT_CORNER_Y.length);
        int n5 = 0;
        int n6 = 1;
        int n7 = nArray.length - 1;
        while (n6 < n7) {
            n5 = Math.max(n5, nArray[n6]);
            int n8 = n6;
            nArray[n8] = nArray[n8] + n;
            int n9 = n6++;
            nArray2[n9] = nArray2[n9] + n2;
        }
        nArray[0] = n;
        nArray2[0] = n2 + n4 - 1;
        n6 = nArray.length - 1;
        nArray[n6] = n + n5;
        nArray2[n6] = n2 + n4 - 1;
        return new Polygon(nArray, nArray2, nArray.length);
    }

    private Polygon rightSide(int n, int n2, int n3, int n4) {
        if (this.getOrientation().isVertical()) {
            int n5 = n;
            n = n2;
            n2 = n5;
            n5 = n3;
            n3 = n4;
            n4 = n5;
        }
        Polygon polygon = this.rightSideTop(n, n2, n3, n4);
        this.transformFromTopToOrientation(polygon);
        return polygon;
    }

    private Polygon rightSideTop(int n, int n2, int n3, int n4) {
        int n5;
        Arch arch = this.arch(n4 * 34 / 22, n4);
        int[] nArray = new int[arch.getWidth() + 1];
        int[] nArray2 = new int[arch.getWidth() + 1];
        int n6 = arch.getWidth();
        for (n5 = 0; n5 < n6; ++n5) {
            nArray[n5] = n + n3 - n6 + n5;
            nArray2[n5] = arch.getValue(n5) + n2;
        }
        n5 = nArray.length - 1;
        nArray[n5] = nArray[0];
        nArray2[n5] = nArray2[n5 - 1];
        return new Polygon(nArray, nArray2, nArray.length);
    }
}

