/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack.tab;

import bibliothek.extension.gui.dock.theme.eclipse.EclipseDockActionSource;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTab;
import bibliothek.extension.gui.dock.theme.eclipse.stack.EclipseTabPane;
import bibliothek.extension.gui.dock.theme.eclipse.stack.tab.TabComponent;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.station.stack.tab.layouting.TabPlacement;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonPanel;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.themes.font.TabFont;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.AbstractUIValue;
import bibliothek.gui.dock.util.font.AbstractDockFont;
import bibliothek.gui.dock.util.font.FontModifier;
import bibliothek.gui.dock.util.swing.OrientedLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public abstract class BaseTabComponent
extends JPanel
implements TabComponent {
    protected final TabColor colorStackTabBorder;
    protected final TabColor colorStackTabBorderSelected;
    protected final TabColor colorStackTabBorderSelectedFocused;
    protected final TabColor colorStackTabBorderSelectedFocusLost;
    protected final TabColor colorStackTabTop;
    protected final TabColor colorStackTabTopSelected;
    protected final TabColor colorStackTabTopSelectedFocused;
    protected final TabColor colorStackTabTopSelectedFocusLost;
    protected final TabColor colorStackTabBottom;
    protected final TabColor colorStackTabBottomSelected;
    protected final TabColor colorStackTabBottomSelectedFocused;
    protected final TabColor colorStackTabBottomSelectedFocusLost;
    protected final TabColor colorStackTabText;
    protected final TabColor colorStackTabTextSelected;
    protected final TabColor colorStackTabTextSelectedFocused;
    protected final TabColor colorStackTabTextSelectedFocusLost;
    protected final TabColor colorStackBorder;
    protected final TabFont fontSelected;
    protected final TabFont fontFocused;
    protected final TabFont fontUnselected;
    private TabColor[] colors;
    private TabFont[] fonts;
    private Dockable dockable;
    private boolean paintIconWhenInactive = false;
    private Icon icon;
    private Insets buttonInsets = new Insets(0, 0, 0, 0);
    private ButtonPanel buttons;
    private boolean hasFocus;
    private boolean isSelected;
    private EclipseTabPane pane;
    private boolean bound;
    private Insets labelInsets = new Insets(0, 0, 0, 0);
    private OrientedLabel label = new OrientedLabel();
    private TabPlacement orientation = TabPlacement.TOP_OF_DOCKABLE;
    private boolean previousTabSelectedSet = false;
    private boolean previousTabSelected = false;
    private boolean nextTabSelectedSet = false;
    private boolean nextTabSelected = false;

    public BaseTabComponent(EclipseTabPane eclipseTabPane, Dockable dockable) {
        this(eclipseTabPane, dockable, null);
    }

    public BaseTabComponent(EclipseTabPane eclipseTabPane, Dockable dockable, String string) {
        super(null);
        if (eclipseTabPane == null) {
            throw new IllegalArgumentException("pane must not be null");
        }
        if (dockable == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        this.pane = eclipseTabPane;
        this.dockable = dockable;
        this.add(this.label);
        DockStation dockStation = eclipseTabPane.getStation();
        if (string == null) {
            string = "";
        }
        this.colorStackTabBorder = new BorderTabColor("stack.tab.border" + string, dockStation, Color.WHITE);
        this.colorStackTabBorderSelected = new BorderTabColor("stack.tab.border.selected" + string, dockStation, Color.WHITE);
        this.colorStackTabBorderSelectedFocused = new BorderTabColor("stack.tab.border.selected.focused" + string, dockStation, Color.WHITE);
        this.colorStackTabBorderSelectedFocusLost = new BorderTabColor("stack.tab.border.selected.focuslost" + string, dockStation, Color.WHITE);
        this.colorStackTabTop = new BaseTabColor("stack.tab.top" + string, dockStation, Color.LIGHT_GRAY);
        this.colorStackTabTopSelected = new BaseTabColor("stack.tab.top.selected" + string, dockStation, Color.LIGHT_GRAY);
        this.colorStackTabTopSelectedFocused = new BaseTabColor("stack.tab.top.selected.focused" + string, dockStation, Color.LIGHT_GRAY);
        this.colorStackTabTopSelectedFocusLost = new BaseTabColor("stack.tab.top.selected.focuslost" + string, dockStation, Color.LIGHT_GRAY);
        this.colorStackTabBottom = new BaseTabColor("stack.tab.bottom" + string, dockStation, Color.WHITE);
        this.colorStackTabBottomSelected = new BaseTabColor("stack.tab.bottom.selected" + string, dockStation, Color.WHITE);
        this.colorStackTabBottomSelectedFocused = new BaseTabColor("stack.tab.bottom.selected.focused" + string, dockStation, Color.WHITE);
        this.colorStackTabBottomSelectedFocusLost = new BaseTabColor("stack.tab.bottom.selected.focuslost" + string, dockStation, Color.WHITE);
        this.colorStackTabText = new BaseTabColor("stack.tab.text" + string, dockStation, Color.BLACK);
        this.colorStackTabTextSelected = new BaseTabColor("stack.tab.text.selected" + string, dockStation, Color.BLACK);
        this.colorStackTabTextSelectedFocused = new BaseTabColor("stack.tab.text.selected.focused" + string, dockStation, Color.BLACK);
        this.colorStackTabTextSelectedFocusLost = new BaseTabColor("stack.tab.text.selected.focuslost" + string, dockStation, Color.BLACK);
        this.colorStackBorder = new BaseTabColor("stack.border" + string, dockStation, Color.BLACK);
        this.fontFocused = new BaseTabFont("tab.focused", dockStation);
        this.fontSelected = new BaseTabFont("tab.selected", dockStation);
        this.fontUnselected = new BaseTabFont("tab.unselected", dockStation);
        this.colors = new TabColor[]{this.colorStackTabBorder, this.colorStackTabBorderSelected, this.colorStackTabBorderSelectedFocused, this.colorStackTabBorderSelectedFocusLost, this.colorStackTabTop, this.colorStackTabTopSelected, this.colorStackTabTopSelectedFocused, this.colorStackTabTopSelectedFocusLost, this.colorStackTabBottom, this.colorStackTabBottomSelected, this.colorStackTabBottomSelectedFocused, this.colorStackTabBottomSelectedFocusLost, this.colorStackTabText, this.colorStackTabTextSelected, this.colorStackTabTextSelectedFocused, this.colorStackTabTextSelectedFocusLost, this.colorStackBorder};
        this.fonts = new TabFont[]{this.fontFocused, this.fontSelected, this.fontUnselected};
        this.setFocusable(false);
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new ContainerOrderFocusTraversalPolicy());
        this.buttons = new ButtonPanel(false);
        this.add(this.buttons);
    }

    protected void addAdditionalColors(TabColor ... tabColorArray) {
        TabColor[] tabColorArray2 = new TabColor[this.colors.length + tabColorArray.length];
        System.arraycopy(this.colors, 0, tabColorArray2, 0, this.colors.length);
        System.arraycopy(tabColorArray, 0, tabColorArray2, this.colors.length, tabColorArray.length);
        this.colors = tabColorArray2;
    }

    public abstract void updateBorder();

    protected void updateFont() {
        TabFont tabFont = null;
        tabFont = this.isFocused() ? this.fontFocused : (this.isSelected() ? this.fontSelected : this.fontUnselected);
        this.label.setFontModifier(tabFont.font());
    }

    public abstract void updateFocus();

    protected abstract void updateSelected();

    protected abstract void updateColors();

    protected void updatePaintIcon() {
        if (this.isSelected() || this.doPaintIconWhenInactive()) {
            this.label.setIcon(this.icon);
        } else {
            this.label.setIcon(null);
        }
        this.revalidate();
        this.repaint();
    }

    protected abstract void updateOrientation();

    public void bind() {
        if (this.buttons != null) {
            this.buttons.set(this.dockable, new EclipseDockActionSource(this.pane.getTheme(), this.dockable.getGlobalActionOffers(), this.dockable, true));
        }
        DockController dockController = this.pane.getController();
        for (TabColor abstractUIValue : this.colors) {
            abstractUIValue.connect(dockController);
        }
        for (AbstractUIValue abstractUIValue : this.fonts) {
            ((AbstractDockFont)abstractUIValue).connect(dockController);
        }
        this.revalidate();
        this.bound = true;
    }

    public void unbind() {
        this.bound = false;
        if (this.buttons != null) {
            this.buttons.set(null);
        }
        for (TabColor abstractUIValue : this.colors) {
            abstractUIValue.connect(null);
        }
        for (AbstractUIValue abstractUIValue : this.fonts) {
            ((AbstractDockFont)abstractUIValue).connect(null);
        }
    }

    public boolean isBound() {
        return this.bound;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public DockElement getElement() {
        return this.dockable;
    }

    public boolean isUsedAsTitle() {
        return true;
    }

    public void addMouseInputListener(MouseInputListener mouseInputListener) {
        this.addMouseListener(mouseInputListener);
        this.addMouseMotionListener(mouseInputListener);
    }

    public void removeMouseInputListener(MouseInputListener mouseInputListener) {
        this.removeMouseListener(mouseInputListener);
        this.removeMouseMotionListener(mouseInputListener);
    }

    public synchronized void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        this.label.addMouseListener(mouseListener);
        this.buttons.addMouseListener(mouseListener);
    }

    public synchronized void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        this.label.removeMouseListener(mouseListener);
        this.buttons.removeMouseListener(mouseListener);
    }

    public synchronized void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        super.addMouseMotionListener(mouseMotionListener);
        this.label.addMouseMotionListener(mouseMotionListener);
        this.buttons.addMouseMotionListener(mouseMotionListener);
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        super.removeMouseMotionListener(mouseMotionListener);
        this.label.removeMouseMotionListener(mouseMotionListener);
        this.buttons.removeMouseMotionListener(mouseMotionListener);
    }

    public Point getPopupLocation(Point point, boolean bl) {
        if (bl) {
            return point;
        }
        return null;
    }

    public DockController getController() {
        return this.pane.getController();
    }

    public DockStation getStation() {
        return this.pane.getStation();
    }

    public EclipseTabPane getPane() {
        return this.pane;
    }

    public Component getComponent() {
        return this;
    }

    public void setFocused(boolean bl) {
        if (this.hasFocus != bl) {
            this.hasFocus = bl;
            this.updateFocus();
        }
    }

    public boolean isFocused() {
        return this.hasFocus;
    }

    public boolean isFocusTemporarilyLost() {
        Window window = SwingUtilities.getWindowAncestor(this.getComponent());
        boolean bl = false;
        if (window != null) {
            bl = !window.isActive();
        }
        return bl;
    }

    public void setSelected(boolean bl) {
        if (this.isSelected != bl) {
            this.isSelected = bl;
            if (this.isSelected() || this.doPaintIconWhenInactive()) {
                this.label.setIcon(this.icon);
            } else {
                this.label.setIcon(null);
            }
            this.revalidate();
            this.updateSelected();
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    protected void setPreviousTabSelected(boolean bl) {
        this.previousTabSelected = bl;
        this.previousTabSelectedSet = true;
    }

    protected void cleanPreviousTabSelected() {
        this.previousTabSelectedSet = false;
    }

    protected boolean isPreviousTabSelected() {
        if (this.previousTabSelectedSet) {
            return this.previousTabSelected;
        }
        EclipseTabPane eclipseTabPane = this.getPane();
        eclipseTabPane.getSelectedIndex();
        int n = this.getTabIndex();
        if (n <= 0) {
            return false;
        }
        EclipseTab eclipseTab = (EclipseTab)eclipseTabPane.getVisibleTab(n - 1);
        return eclipseTab.getDockable() == eclipseTabPane.getSelectedDockable();
    }

    protected void setNextTabSelected(boolean bl) {
        this.nextTabSelected = bl;
        this.nextTabSelectedSet = true;
    }

    protected void cleanNextTabSelected() {
        this.nextTabSelectedSet = false;
    }

    protected boolean isNextTabSelected() {
        if (this.nextTabSelectedSet) {
            return this.nextTabSelected;
        }
        EclipseTabPane eclipseTabPane = this.getPane();
        int n = this.getTabIndex();
        if (n >= eclipseTabPane.getVisibleTabCount()) {
            return false;
        }
        EclipseTab eclipseTab = (EclipseTab)eclipseTabPane.getVisibleTab(n + 1);
        if (eclipseTab == null) {
            return false;
        }
        return eclipseTab.getDockable() == eclipseTabPane.getSelectedDockable();
    }

    public int getDockableIndex() {
        EclipseTabPane eclipseTabPane = this.getPane();
        if (eclipseTabPane == null || !this.isBound()) {
            return -1;
        }
        return eclipseTabPane.indexOf(this.getDockable());
    }

    public int getTabIndex() {
        EclipseTabPane eclipseTabPane = this.getPane();
        if (eclipseTabPane == null || !this.isBound()) {
            return -1;
        }
        return eclipseTabPane.indexOfVisible(this);
    }

    public boolean doPaintIconWhenInactive() {
        return this.paintIconWhenInactive;
    }

    public void setPaintIconWhenInactive(boolean bl) {
        if (this.paintIconWhenInactive != bl) {
            this.paintIconWhenInactive = bl;
            this.updatePaintIcon();
        }
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        if (this.isSelected() || this.doPaintIconWhenInactive()) {
            this.label.setIcon(icon);
            this.revalidate();
        }
    }

    public Icon getIcon() {
        return this.label.getIcon();
    }

    public void setText(String string) {
        this.label.setText(string);
        this.revalidate();
    }

    public void setTooltip(String string) {
        this.setToolTipText(string);
    }

    public String getText() {
        return this.label.getText();
    }

    public void setLabelInsets(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("insets must not be null");
        }
        this.labelInsets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
        this.revalidate();
    }

    public Insets getLabelInsets() {
        return this.labelInsets;
    }

    public void setButtonInsets(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("insets must not be null");
        }
        this.buttonInsets = insets;
        this.revalidate();
    }

    public Insets getButtonInsets() {
        return this.buttonInsets;
    }

    protected OrientedLabel getLabel() {
        return this.label;
    }

    public ButtonPanel getButtons() {
        return this.buttons;
    }

    public void setOrientation(TabPlacement tabPlacement) {
        if (tabPlacement == null) {
            throw new IllegalArgumentException("orientation must not be null");
        }
        if (this.orientation != tabPlacement) {
            this.orientation = tabPlacement;
            switch (tabPlacement) {
                case TOP_OF_DOCKABLE: {
                    this.buttons.setOrientation(DockTitle.Orientation.NORTH_SIDED);
                    this.label.setHorizontal(true);
                    break;
                }
                case BOTTOM_OF_DOCKABLE: {
                    this.buttons.setOrientation(DockTitle.Orientation.SOUTH_SIDED);
                    this.label.setHorizontal(true);
                    break;
                }
                case LEFT_OF_DOCKABLE: {
                    this.buttons.setOrientation(DockTitle.Orientation.EAST_SIDED);
                    this.label.setHorizontal(false);
                    break;
                }
                case RIGHT_OF_DOCKABLE: {
                    this.buttons.setOrientation(DockTitle.Orientation.WEST_SIDED);
                    this.label.setHorizontal(false);
                }
            }
            this.updateOrientation();
        }
    }

    public TabPlacement getOrientation() {
        return this.orientation;
    }

    public Dimension getMinimumSize(TabComponent[] tabComponentArray) {
        this.setSelection(tabComponentArray);
        Dimension dimension = this.getMinimumSize();
        this.unsetSelection();
        return dimension;
    }

    public Dimension getPreferredSize(TabComponent[] tabComponentArray) {
        this.setSelection(tabComponentArray);
        Dimension dimension = this.getPreferredSize();
        this.unsetSelection();
        return dimension;
    }

    private void setSelection(TabComponent[] tabComponentArray) {
        Dockable dockable = this.getPane().getSelectedDockable();
        for (int i = 0; i < tabComponentArray.length; ++i) {
            if (tabComponentArray[i] != this) continue;
            if (i > 0 && tabComponentArray[i - 1] instanceof BaseTabComponent) {
                this.setPreviousTabSelected(((BaseTabComponent)tabComponentArray[i - 1]).getDockable() == dockable);
            }
            if (i + 1 >= tabComponentArray.length || !(tabComponentArray[i + 1] instanceof BaseTabComponent)) break;
            this.setNextTabSelected(((BaseTabComponent)tabComponentArray[i + 1]).getDockable() == dockable);
            break;
        }
    }

    private void unsetSelection() {
        this.cleanNextTabSelected();
        this.cleanPreviousTabSelected();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (this.label == null) {
            return new Dimension(1, 1);
        }
        Dimension dimension = this.label.getPreferredSize();
        Dimension dimension2 = this.buttons.getPreferredSize();
        if (this.orientation.isHorizontal()) {
            return new Dimension(dimension.width + dimension2.width + this.labelInsets.left + this.labelInsets.right + this.buttonInsets.left + this.buttonInsets.right, Math.max(dimension.height + this.labelInsets.top + this.labelInsets.bottom, dimension2.height + this.buttonInsets.top + this.buttonInsets.bottom));
        }
        return new Dimension(Math.max(dimension.width + this.labelInsets.left + this.labelInsets.right, dimension2.width + this.buttonInsets.left + this.buttonInsets.right), dimension.height + dimension2.height + this.labelInsets.top + this.labelInsets.bottom + this.buttonInsets.top + this.buttonInsets.bottom);
    }

    public void doLayout() {
        if (this.label != null && this.buttons != null) {
            Dimension dimension = this.label.getPreferredSize();
            Dimension dimension2 = this.buttons.getPreferredSize();
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (this.orientation.isHorizontal()) {
                int n3 = dimension.height + this.labelInsets.top + this.labelInsets.bottom;
                int n4 = dimension2.height + this.buttonInsets.top + this.buttonInsets.bottom;
                this.label.setBounds(this.labelInsets.left, (n2 - n3) / 2 + this.labelInsets.top, dimension.width, dimension.height);
                this.buttons.setBounds(n - dimension2.width - this.buttonInsets.right, (n2 - n4) / 2 + this.buttonInsets.top, dimension2.width, dimension2.height);
            } else {
                int n5 = dimension.width + this.labelInsets.left + this.labelInsets.right;
                int n6 = dimension2.width + this.buttonInsets.left + this.buttonInsets.right;
                this.label.setBounds((n - n5) / 2 + this.labelInsets.left, this.labelInsets.top, dimension.width, dimension.height);
                this.buttons.setBounds((n - n6) / 2 + this.buttonInsets.left, n2 - dimension2.height - this.buttonInsets.bottom, dimension2.width, dimension2.height);
            }
            this.repaint();
        }
    }

    private class BaseTabFont
    extends TabFont {
        public BaseTabFont(String string, DockStation dockStation) {
            super(string, dockStation, BaseTabComponent.this.dockable);
        }

        protected void changed(FontModifier fontModifier, FontModifier fontModifier2) {
            BaseTabComponent.this.updateFont();
        }
    }

    private class BaseTabColor
    extends TabColor {
        public BaseTabColor(String string, DockStation dockStation, Color color) {
            super(string, dockStation, BaseTabComponent.this.dockable, color);
        }

        protected void changed(Color color, Color color2) {
            BaseTabComponent.this.updateColors();
        }
    }

    private class BorderTabColor
    extends TabColor {
        public BorderTabColor(String string, DockStation dockStation, Color color) {
            super(string, dockStation, BaseTabComponent.this.dockable, color);
        }

        protected void changed(Color color, Color color2) {
            BaseTabComponent.this.updateBorder();
        }
    }
}

