/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.flat;

import bibliothek.gui.DockController;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.themes.color.DisplayerColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class FlatBorder
implements Border {
    private static final float FACTOR = 0.85f;
    private DockableDisplayer owner;
    private BorderColor background = new BorderColor("displayer.border");
    private BorderColor light = new BorderColor("displayer.border.light");
    private BorderColor dark = new BorderColor("displayer.border.dark");
    private BorderColor middle = new BorderColor("displayer.border.middle");

    public FlatBorder(DockableDisplayer dockableDisplayer) {
        this.owner = dockableDisplayer;
    }

    public void connect(DockController dockController) {
        this.background.connect(dockController);
        this.light.connect(dockController);
        this.dark.connect(dockController);
        this.middle.connect(dockController);
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        Color color = (Color)this.background.value();
        Color color2 = (Color)this.light.value();
        Color color3 = (Color)this.middle.value();
        Color color4 = (Color)this.dark.value();
        if (color == null) {
            color = component.getBackground();
        }
        if (color2 == null) {
            color2 = this.darker(color);
        }
        if (color3 == null) {
            color3 = this.darker(color2);
        }
        if (color4 == null) {
            color4 = this.darker(color3);
        }
        graphics.setColor(color4);
        graphics.drawRect(n, n2, n3 - 3, n4 - 3);
        graphics.setColor(color3);
        graphics.drawLine(n + n3 - 2, n2 + 1, n + n3 - 2, n2 + n4 - 3);
        graphics.drawLine(n + n3 - 3, n2, n + n3 - 3, n2);
        graphics.drawLine(n, n2 + n4 - 3, n, n2 + n4 - 3);
        graphics.drawLine(n + 1, n2 + n4 - 2, n + n3 - 3, n2 + n4 - 2);
        graphics.setColor(color2);
        graphics.drawLine(n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 2);
        graphics.drawLine(n + n3 - 2, n2, n + n3 - 2, n2);
        graphics.drawLine(n, n2 + n4 - 2, n, n2 + n4 - 2);
        graphics.drawLine(n + 1, n2 + n4 - 1, n + n3 - 2, n2 + n4 - 1);
        graphics.drawLine(n + n3 - 2, n2 + n4 - 2, n + n3 - 2, n2 + n4 - 2);
    }

    private Color darker(Color color) {
        return new Color(Math.max((int)((float)color.getRed() * 0.85f), 0), Math.max((int)((float)color.getGreen() * 0.85f), 0), Math.max((int)((float)color.getBlue() * 0.85f), 0));
    }

    public Insets getBorderInsets(Component component) {
        return new Insets(1, 1, 3, 3);
    }

    public boolean isBorderOpaque() {
        return false;
    }

    private class BorderColor
    extends DisplayerColor {
        public BorderColor(String string) {
            super(string, FlatBorder.this.owner, null);
        }

        protected void changed(Color color, Color color2) {
            FlatBorder.this.owner.getComponent().repaint();
        }
    }
}

