/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.smooth;

import bibliothek.extension.gui.dock.theme.smooth.SmoothChanger;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.themes.basic.BasicStationTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.util.Colors;

public class SmoothDefaultStationTitle
extends BasicStationTitle {
    private int current = 0;
    private SmoothChanger changer = new SmoothChanger(2){

        protected int destination() {
            if (SmoothDefaultStationTitle.this.isActive()) {
                return 0;
            }
            return 1;
        }

        protected void repaint(int[] nArray) {
            SmoothDefaultStationTitle.this.current = nArray[0];
            SmoothDefaultStationTitle.this.updateColors();
        }
    };

    public void setActive(boolean bl) {
        super.setActive(bl);
        if (this.changer != null) {
            this.changer.trigger();
        }
    }

    public SmoothDefaultStationTitle(Dockable dockable, DockTitleVersion dockTitleVersion) {
        super(dockable, dockTitleVersion);
    }

    public int getDuration() {
        return this.changer.getDuration();
    }

    public void setDuration(int n) {
        this.changer.setDuration(n);
    }

    protected void updateColors() {
        super.updateColors();
        if (this.changer != null) {
            int n = this.getDuration();
            if (this.isActive() && this.current != n || !this.isActive() && this.current != 0) {
                double d = (double)this.current / (double)n;
                this.setForeground(Colors.between(this.getInactiveTextColor(), this.getActiveTextColor(), d));
                this.setBackground(Colors.between(this.getInactiveColor(), this.getActiveColor(), d));
            }
        }
    }
}

