/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public abstract class MouseOverListener
extends MouseAdapter
implements ContainerListener {
    private boolean mouseover = false;

    public MouseOverListener(Component component) {
        this.added(component);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.mouseover = true;
        this.changed();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mouseover = false;
        this.changed();
    }

    protected abstract void changed();

    public boolean isMouseOver() {
        return this.mouseover;
    }

    public void componentAdded(ContainerEvent containerEvent) {
        this.added(containerEvent.getChild());
    }

    protected void added(Component component) {
        component.addMouseListener(this);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.addContainerListener(this);
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                this.added(container.getComponent(i));
            }
        }
    }

    public void componentRemoved(ContainerEvent containerEvent) {
        this.removed(containerEvent.getChild());
    }

    protected void removed(Component component) {
        component.removeMouseListener(this);
        if (component instanceof Container) {
            Container container = (Container)component;
            container.removeContainerListener(this);
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                this.removed(container.getComponent(i));
            }
        }
    }
}

