/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.actions;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionType;
import bibliothek.gui.dock.action.DefaultDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DropDownAction;
import bibliothek.gui.dock.action.actions.SimpleDockAction;
import bibliothek.gui.dock.action.dropdown.DefaultDropDownFilter;
import bibliothek.gui.dock.action.dropdown.DropDownFilterFactory;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.DropDownActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDropDownAction
extends SimpleDockAction
implements DropDownAction {
    private DockAction selection;
    private List<DropDownActionListener> listeners = new ArrayList<DropDownActionListener>();
    private DefaultDockActionSource actions = new DefaultDockActionSource(new DockAction[0]);
    private DropDownFilterFactory filter = DefaultDropDownFilter.FACTORY;

    @Override
    public <V> V createView(ViewTarget<V> viewTarget, ActionViewConverter actionViewConverter, Dockable dockable) {
        return actionViewConverter.createView(ActionType.DROP_DOWN, this, viewTarget, dockable);
    }

    @Override
    public DockAction getSelection(Dockable dockable) {
        return this.selection;
    }

    @Override
    public void setSelection(Dockable dockable, DockAction dockAction) {
        this.setSelection(dockAction);
    }

    public void setSelection(DockAction dockAction) {
        if (this.selection != dockAction) {
            this.selection = dockAction;
            this.fireSelectionChanged();
        }
    }

    public void setFilter(DropDownFilterFactory dropDownFilterFactory) {
        if (dropDownFilterFactory == null) {
            throw new IllegalArgumentException("Filter must not be null");
        }
        this.filter = dropDownFilterFactory;
    }

    @Override
    public DropDownFilterFactory getFilter(Dockable dockable) {
        return this.filter;
    }

    public void add(DockAction dockAction) {
        this.actions.add(dockAction);
    }

    public void insert(int n, DockAction dockAction) {
        this.actions.add(n, dockAction);
    }

    public void insert(int n, DockAction ... dockActionArray) {
        this.actions.add(n, dockActionArray);
    }

    public void remove(int n) {
        DockAction dockAction = this.actions.getDockAction(n);
        this.actions.remove(n);
        if (this.selection == dockAction) {
            this.setSelection(null, null);
        }
    }

    public int size() {
        return this.actions.getDockActionCount();
    }

    public void remove(DockAction dockAction) {
        this.actions.remove(dockAction);
        if (this.selection == dockAction) {
            this.setSelection(null, null);
        }
    }

    @Override
    public DefaultDockActionSource getSubActions(Dockable dockable) {
        return this.actions;
    }

    @Override
    public void addDropDownActionListener(DropDownActionListener dropDownActionListener) {
        this.listeners.add(dropDownActionListener);
    }

    @Override
    public void removeDropDownActionListener(DropDownActionListener dropDownActionListener) {
        this.listeners.remove(dropDownActionListener);
    }

    protected DropDownActionListener[] getListeners() {
        return this.listeners.toArray(new DropDownActionListener[this.listeners.size()]);
    }

    protected void fireSelectionChanged() {
        Set<Dockable> set = this.getBoundDockables();
        for (DropDownActionListener dropDownActionListener : this.getListeners()) {
            dropDownActionListener.selectionChanged(this, set, this.selection);
        }
    }

    @Override
    public boolean trigger(Dockable dockable) {
        if (!this.isEnabled(dockable)) {
            return false;
        }
        if (this.selection != null) {
            return this.selection.trigger(dockable);
        }
        return false;
    }
}

