/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.actions;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionType;
import bibliothek.gui.dock.action.SelectableDockAction;
import bibliothek.gui.dock.action.actions.SimpleDropDownItemAction;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.event.SelectableDockActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleSelectableAction
extends SimpleDropDownItemAction
implements SelectableDockAction {
    private List<SelectableDockActionListener> listeners = new ArrayList<SelectableDockActionListener>();
    private boolean selected = false;
    private Icon selectedIcon;
    private Icon disabledSelectedIcon;
    private ActionType<SelectableDockAction> type;

    public SimpleSelectableAction(ActionType<SelectableDockAction> actionType) {
        if (actionType == null) {
            throw new IllegalArgumentException("Type must not be null");
        }
        this.type = actionType;
    }

    @Override
    public <V> V createView(ViewTarget<V> viewTarget, ActionViewConverter actionViewConverter, Dockable dockable) {
        return actionViewConverter.createView(this.type, this, viewTarget, dockable);
    }

    @Override
    public void addSelectableListener(SelectableDockActionListener selectableDockActionListener) {
        this.listeners.add(selectableDockActionListener);
    }

    @Override
    public void removeSelectableListener(SelectableDockActionListener selectableDockActionListener) {
        this.listeners.remove(selectableDockActionListener);
    }

    protected void fireSelectedChanged() {
        Set<Dockable> set = this.getBoundDockables();
        for (SelectableDockActionListener selectableDockActionListener : this.listeners.toArray(new SelectableDockActionListener[this.listeners.size()])) {
            selectableDockActionListener.selectedChanged(this, set);
        }
    }

    @Override
    public boolean isSelected(Dockable dockable) {
        return this.selected;
    }

    @Override
    public void setSelected(Dockable dockable, boolean bl) {
        this.setSelected(bl);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean bl) {
        if (bl != this.selected) {
            this.selected = bl;
            this.fireSelectedChanged();
            this.fireActionIconChanged(this.getBoundDockables());
            this.fireActionDisabledIconChanged(this.getBoundDockables());
        }
    }

    @Override
    public Icon getIcon(Dockable dockable) {
        if (this.isSelected()) {
            return this.firstNonNull(this.selectedIcon, super.getIcon(dockable));
        }
        return super.getIcon(dockable);
    }

    protected Icon firstNonNull(Icon ... iconArray) {
        for (Icon icon : iconArray) {
            if (icon == null) continue;
            return icon;
        }
        return null;
    }

    public Icon getSelectedIcon() {
        return this.selectedIcon;
    }

    public void setSelectedIcon(Icon icon) {
        this.selectedIcon = icon;
        this.fireActionIconChanged(this.getBoundDockables());
    }

    public Icon getDisabledSelectedIcon() {
        return this.disabledSelectedIcon;
    }

    @Override
    public Icon getDisabledIcon(Dockable dockable) {
        if (this.selected) {
            return this.firstNonNull(this.disabledSelectedIcon, super.getDisabledIcon(dockable));
        }
        return super.getDisabledIcon(dockable);
    }

    public void setDisabledSelectedIcon(Icon icon) {
        this.disabledSelectedIcon = icon;
        this.fireActionDisabledIconChanged(this.getBoundDockables());
    }

    public static class Radio
    extends SimpleSelectableAction {
        public Radio() {
            super(ActionType.RADIO);
            this.setDropDownTriggerableSelected(false);
        }

        public boolean trigger(Dockable dockable) {
            if (!this.isEnabled(dockable) || this.isSelected(dockable)) {
                return false;
            }
            this.setSelected(dockable, true);
            return true;
        }
    }

    public static class Check
    extends SimpleSelectableAction {
        public Check() {
            super(ActionType.CHECK);
            this.setDropDownSelectable(false);
        }

        public boolean trigger(Dockable dockable) {
            if (!this.isEnabled(dockable)) {
                return false;
            }
            this.setSelected(dockable, !this.isSelected(dockable));
            return true;
        }
    }
}

