/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.flap;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.station.OverpaintablePanel;
import bibliothek.gui.dock.station.StationChildHandle;
import bibliothek.gui.dock.station.flap.ButtonPane;
import bibliothek.gui.dock.station.flap.FlapDropInfo;
import bibliothek.gui.dock.station.flap.FlapWindow;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleVersion;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;

public class DefaultFlapWindow
implements FlapWindow,
MouseListener,
MouseMotionListener {
    private StationChildHandle dockable;
    private DockableDisplayerListener displayerListener = new DockableDisplayerListener(){

        public void discard(DockableDisplayer dockableDisplayer) {
            DefaultFlapWindow.this.discardDisplayer();
        }
    };
    private boolean pressed;
    private FlapDockStation station;
    private ButtonPane buttonPane;
    private FlapDropInfo dropInfo;
    private JComponent contentPane;
    private Parent window;

    public DefaultFlapWindow(FlapDockStation flapDockStation, ButtonPane buttonPane, Parent parent) {
        this.station = flapDockStation;
        this.buttonPane = buttonPane;
        this.window = parent;
        this.init();
    }

    private void init() {
        OverpaintablePanel overpaintablePanel = new OverpaintablePanel(){

            protected void paintOverlay(Graphics graphics) {
                if (DefaultFlapWindow.this.dropInfo != null && DefaultFlapWindow.this.dropInfo.getCombine() != null && DefaultFlapWindow.this.dropInfo.isDraw()) {
                    Rectangle rectangle = new Rectangle(0, 0, this.getWidth(), this.getHeight());
                    DefaultFlapWindow.this.station.getPaint().drawInsertion(graphics, DefaultFlapWindow.this.station, rectangle, rectangle);
                }
            }
        };
        this.window.setContentPane(overpaintablePanel);
        this.contentPane = overpaintablePanel.getContentPane();
        this.contentPane.setBorder(BorderFactory.createBevelBorder(0));
        this.contentPane.addMouseListener(this);
        this.contentPane.addMouseMotionListener(this);
        this.contentPane.setLayout(new LayoutManager(){

            public void addLayoutComponent(String string, Component component) {
            }

            public void removeLayoutComponent(Component component) {
            }

            public Dimension preferredLayoutSize(Container container) {
                DockableDisplayer dockableDisplayer = DefaultFlapWindow.this.getDisplayer();
                if (dockableDisplayer == null) {
                    return new Dimension(100, 100);
                }
                return dockableDisplayer.getComponent().getPreferredSize();
            }

            public Dimension minimumLayoutSize(Container container) {
                DockableDisplayer dockableDisplayer = DefaultFlapWindow.this.getDisplayer();
                if (dockableDisplayer == null) {
                    return new Dimension(100, 100);
                }
                return dockableDisplayer.getComponent().getMinimumSize();
            }

            public void layoutContainer(Container container) {
                DockableDisplayer dockableDisplayer = DefaultFlapWindow.this.getDisplayer();
                if (dockableDisplayer != null) {
                    Insets insets = container.getInsets();
                    insets = new Insets(insets.top, insets.left, insets.bottom, insets.right);
                    if (DefaultFlapWindow.this.station.getDirection() == FlapDockStation.Direction.SOUTH) {
                        insets.bottom += DefaultFlapWindow.this.station.getWindowBorder();
                    } else if (DefaultFlapWindow.this.station.getDirection() == FlapDockStation.Direction.NORTH) {
                        insets.top += DefaultFlapWindow.this.station.getWindowBorder();
                    } else if (DefaultFlapWindow.this.station.getDirection() == FlapDockStation.Direction.EAST) {
                        insets.right += DefaultFlapWindow.this.station.getWindowBorder();
                    } else {
                        insets.left += DefaultFlapWindow.this.station.getWindowBorder();
                    }
                    dockableDisplayer.getComponent().setBounds(insets.left, insets.top, container.getWidth() - insets.left - insets.right, container.getHeight() - insets.top - insets.bottom);
                }
            }
        });
        this.window.asComponent().addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
            }

            public void componentShown(ComponentEvent componentEvent) {
                if (!DefaultFlapWindow.this.station.isFlapWindow(DefaultFlapWindow.this) || DefaultFlapWindow.this.getDockable() == null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DefaultFlapWindow.this.window.destroy();
                        }
                    });
                }
            }
        });
    }

    public void setWindowVisible(boolean bl) {
        if (bl) {
            this.updateBounds();
        }
        this.window.setVisible(bl);
    }

    public boolean isWindowVisible() {
        return this.window.isVisible();
    }

    public Rectangle getWindowBounds() {
        return this.window.asComponent().getBounds();
    }

    public void destory() {
        this.setDockable(null);
        this.window.destroy();
    }

    public void repaint() {
        this.window.asComponent().repaint();
    }

    public boolean isWindowValid() {
        return this.window.isParentValid();
    }

    public boolean containsScreenPoint(Point point) {
        point = new Point(point);
        Component component = this.window.asComponent();
        SwingUtilities.convertPointFromScreen(point, component);
        return component.contains(point);
    }

    public FlapDockStation getStation() {
        return this.station;
    }

    public void setDropInfo(FlapDropInfo flapDropInfo) {
        this.dropInfo = flapDropInfo;
        this.repaint();
    }

    public void setDockTitle(DockTitleVersion dockTitleVersion) {
        if (this.dockable != null) {
            this.dockable.setTitleRequest(dockTitleVersion);
        }
    }

    public DockTitle getDockTitle() {
        if (this.dockable == null) {
            return null;
        }
        return this.dockable.getTitle();
    }

    public Dockable getDockable() {
        if (this.dockable == null) {
            return null;
        }
        return this.dockable.getDockable();
    }

    public DockableDisplayer getDisplayer() {
        if (this.dockable == null) {
            return null;
        }
        return this.dockable.getDisplayer();
    }

    public void setDockable(Dockable dockable) {
        DockableDisplayer dockableDisplayer;
        Container container = this.getDisplayerParent();
        if (this.dockable != null) {
            dockableDisplayer = this.getDisplayer();
            dockableDisplayer.removeDockableDisplayerListener(this.displayerListener);
            container.remove(dockableDisplayer.getComponent());
            this.dockable.destroy();
            this.dockable = null;
        }
        if (dockable != null) {
            this.dockable = new StationChildHandle(this.station, this.station.getDisplayers(), dockable, this.station.getTitleVersion());
            this.dockable.updateDisplayer();
            dockableDisplayer = this.getDisplayer();
            dockableDisplayer.addDockableDisplayerListener(this.displayerListener);
            container.add(dockableDisplayer.getComponent());
        }
    }

    protected void discardDisplayer() {
        if (this.dockable != null) {
            DockableDisplayer dockableDisplayer = this.dockable.getDisplayer();
            dockableDisplayer.removeDockableDisplayerListener(this.displayerListener);
            this.contentPane.remove(dockableDisplayer.getComponent());
            this.dockable.updateDisplayer();
            dockableDisplayer = this.dockable.getDisplayer();
            dockableDisplayer.addDockableDisplayerListener(this.displayerListener);
            this.contentPane.add(dockableDisplayer.getComponent());
            this.updateBounds();
        }
    }

    protected Container getDisplayerParent() {
        return this.contentPane;
    }

    public Insets getDockableInsets() {
        DockableDisplayer dockableDisplayer = this.dockable.getDisplayer();
        Insets insets = dockableDisplayer.getDockableInsets();
        dockableDisplayer.getComponent().getBounds();
        Component component = this.window.asComponent();
        Point point = new Point(0, 0);
        point = SwingUtilities.convertPoint(dockableDisplayer.getComponent(), point, component);
        int n = point.x;
        int n2 = point.y;
        int n3 = component.getWidth() - dockableDisplayer.getComponent().getWidth();
        int n4 = component.getHeight() - dockableDisplayer.getComponent().getHeight();
        insets.left += n;
        insets.top += n2;
        insets.right += n3 - n;
        insets.bottom += n4 - n2;
        return insets;
    }

    public void updateBounds() {
        Dockable dockable;
        DockableDisplayer dockableDisplayer = this.getDisplayer();
        Dockable dockable2 = dockable = dockableDisplayer == null ? null : dockableDisplayer.getDockable();
        if (dockable != null) {
            Dimension dimension;
            Point point;
            this.window.asComponent().validate();
            FlapDockStation.Direction direction = this.station.getDirection();
            int n = this.station.getWindowSize(dockable);
            Rectangle rectangle = this.station.getExpansionBounds();
            Insets insets = this.getDockableInsets();
            if (direction == FlapDockStation.Direction.SOUTH) {
                point = new Point(rectangle.x, rectangle.height);
                dimension = new Dimension(rectangle.width, n += insets.top + insets.bottom);
            } else if (direction == FlapDockStation.Direction.NORTH) {
                point = new Point(rectangle.x, -(n += insets.top + insets.bottom));
                dimension = new Dimension(rectangle.width, n);
            } else if (direction == FlapDockStation.Direction.WEST) {
                point = new Point(-(n += insets.left + insets.right), rectangle.y);
                dimension = new Dimension(n, rectangle.height);
            } else {
                point = new Point(rectangle.width, rectangle.y);
                dimension = new Dimension(n += insets.left + insets.right, rectangle.height);
            }
            SwingUtilities.convertPointToScreen(point, this.buttonPane);
            this.window.setParentLocation(point);
            this.window.setSize(dimension);
            this.window.asComponent().validate();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.pressed) {
            this.window.asComponent().setCursor(Cursor.getDefaultCursor());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.station.getDirection() == FlapDockStation.Direction.SOUTH) {
            this.window.asComponent().setCursor(Cursor.getPredefinedCursor(9));
        } else if (this.station.getDirection() == FlapDockStation.Direction.NORTH) {
            this.window.asComponent().setCursor(Cursor.getPredefinedCursor(8));
        } else if (this.station.getDirection() == FlapDockStation.Direction.EAST) {
            this.window.asComponent().setCursor(Cursor.getPredefinedCursor(11));
        } else {
            this.window.asComponent().setCursor(Cursor.getPredefinedCursor(10));
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.pressed = true;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.pressed = false;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.pressed) {
            Dockable dockable;
            DockableDisplayer dockableDisplayer = this.getDisplayer();
            Dockable dockable2 = dockable = dockableDisplayer == null ? null : dockableDisplayer.getDockable();
            if (dockable != null) {
                Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
                SwingUtilities.convertPointToScreen(point, mouseEvent.getComponent());
                Component component = this.station.getComponent();
                Point point2 = new Point(0, 0);
                SwingUtilities.convertPointToScreen(point2, component);
                int n = 0;
                n = this.station.getDirection() == FlapDockStation.Direction.SOUTH ? point.y - point2.y - component.getHeight() : (this.station.getDirection() == FlapDockStation.Direction.NORTH ? point2.y - point.y : (this.station.getDirection() == FlapDockStation.Direction.EAST ? point.x - point2.x - component.getWidth() : point2.x - point.x));
                n = Math.max(n, this.station.getWindowMinSize());
                Insets insets = this.getDockableInsets();
                n = this.station.getDirection() == FlapDockStation.Direction.NORTH || this.station.getDirection() == FlapDockStation.Direction.SOUTH ? (n -= insets.top + insets.bottom) : (n -= insets.left + insets.right);
                if (n > 0) {
                    this.station.setWindowSize(dockable, n);
                }
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public static class DialogParent
    extends JDialog
    implements Parent {
        private FlapDockStation station;

        public DialogParent(Frame frame, FlapDockStation flapDockStation) {
            super(frame, false);
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(0);
            this.station = flapDockStation;
        }

        public DialogParent(Dialog dialog, FlapDockStation flapDockStation) {
            super(dialog, false);
            this.setUndecorated(true);
            this.getRootPane().setWindowDecorationStyle(0);
            this.station = flapDockStation;
        }

        public Component asComponent() {
            return this;
        }

        public boolean isParentValid() {
            Window window = SwingUtilities.getWindowAncestor(this.station.getComponent());
            return this.getOwner() == window;
        }

        public void setParentLocation(Point point) {
            this.setLocation(point);
        }

        public void destroy() {
            this.dispose();
        }
    }

    public static interface Parent {
        public boolean isParentValid();

        public Component asComponent();

        public void setParentLocation(Point var1);

        public void setSize(Dimension var1);

        public boolean isVisible();

        public void setVisible(boolean var1);

        public void setContentPane(Container var1);

        public Container getContentPane();

        public void destroy();
    }
}

