/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack.tab;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.station.stack.StackDockComponent;
import bibliothek.gui.dock.station.stack.TabContent;
import bibliothek.gui.dock.station.stack.TabContentFilterListener;
import bibliothek.gui.dock.station.stack.tab.TabContentFilter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class AbstractTabContentFilter
implements TabContentFilter {
    private List<TabContentFilterListener> listeners = new ArrayList<TabContentFilterListener>();
    protected List<StackDockStation> stations = new ArrayList<StackDockStation>();
    protected List<StackDockComponent> components = new ArrayList<StackDockComponent>();
    private DockStationListener stationListener = new DockStationAdapter(){

        public void dockableAdding(DockStation dockStation, Dockable dockable) {
            AbstractTabContentFilter.this.added((StackDockStation)dockStation, dockable);
        }

        public void dockableRemoved(DockStation dockStation, Dockable dockable) {
            AbstractTabContentFilter.this.removed((StackDockStation)dockStation, dockable);
        }

        public void dockableSelected(DockStation dockStation, Dockable dockable, Dockable dockable2) {
            if (dockable != dockable2) {
                if (dockable != null) {
                    AbstractTabContentFilter.this.deselected((StackDockStation)dockStation, dockable);
                }
                if (dockable2 != null) {
                    AbstractTabContentFilter.this.selected((StackDockStation)dockStation, dockable2);
                }
            }
        }
    };
    private ChangeListener componentListener = new ChangeListener(){

        public void stateChanged(ChangeEvent changeEvent) {
        }
    };

    public void addListener(TabContentFilterListener tabContentFilterListener) {
        if (tabContentFilterListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(tabContentFilterListener);
    }

    public void removeListener(TabContentFilterListener tabContentFilterListener) {
        this.listeners.remove(tabContentFilterListener);
    }

    protected TabContentFilterListener[] listeners() {
        return this.listeners.toArray(new TabContentFilterListener[this.listeners.size()]);
    }

    protected void fireChanged() {
        for (TabContentFilterListener tabContentFilterListener : this.listeners()) {
            tabContentFilterListener.contentChanged();
        }
    }

    protected void fireChanged(Dockable dockable) {
        for (TabContentFilterListener tabContentFilterListener : this.listeners()) {
            tabContentFilterListener.contentChanged(dockable);
        }
    }

    protected void fireChanged(StackDockStation stackDockStation) {
        for (TabContentFilterListener tabContentFilterListener : this.listeners()) {
            tabContentFilterListener.contentChanged(stackDockStation);
        }
    }

    protected void fireChanged(StackDockComponent stackDockComponent) {
        for (TabContentFilterListener tabContentFilterListener : this.listeners()) {
            tabContentFilterListener.contentChanged(stackDockComponent);
        }
    }

    public void install(StackDockStation stackDockStation) {
        this.stations.add(stackDockStation);
        stackDockStation.addDockStationListener(this.stationListener);
    }

    public void install(StackDockComponent stackDockComponent) {
        this.components.add(stackDockComponent);
        stackDockComponent.addChangeListener(this.componentListener);
    }

    public void uninstall(StackDockStation stackDockStation) {
        this.stations.remove(stackDockStation);
        stackDockStation.removeDockStationListener(this.stationListener);
    }

    public void uninstall(StackDockComponent stackDockComponent) {
        this.components.remove(stackDockComponent);
        stackDockComponent.removeChangeListener(this.componentListener);
    }

    public TabContent filter(TabContent tabContent, StackDockStation stackDockStation, Dockable dockable) {
        return tabContent;
    }

    public TabContent filter(TabContent tabContent, StackDockComponent stackDockComponent, Dockable dockable) {
        return tabContent;
    }

    protected void added(StackDockStation stackDockStation, Dockable dockable) {
    }

    protected void removed(StackDockStation stackDockStation, Dockable dockable) {
    }

    protected void selected(StackDockStation stackDockStation, Dockable dockable) {
    }

    protected void deselected(StackDockStation stackDockStation, Dockable dockable) {
    }

    protected void selectionChanged(StackDockComponent stackDockComponent) {
    }
}

