/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.support;

import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.PlaceholderStrategyListener;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaceholderMap {
    private int version;
    private Path format;
    private Map<Key, Map<String, Object>> data = new LinkedHashMap<Key, Map<String, Object>>();
    private PlaceholderStrategy strategy;
    private PlaceholderStrategyListener listener = new PlaceholderStrategyListener(){

        @Override
        public void placeholderInvalidated(Set<Path> set) {
            PlaceholderMap.this.removeAll(set, false);
        }
    };

    public PlaceholderMap(Path path, int n) {
        if (path == null) {
            throw new IllegalArgumentException("format must not be null");
        }
        this.format = path;
        this.version = n;
    }

    public PlaceholderMap(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
        this.setPlaceholderStrategy(placeholderStrategy);
        Version version = Version.read(dataInputStream);
        if (version.compareTo(Version.VERSION_1_0_8) != 0) {
            throw new IOException("unknown version: " + version);
        }
        this.version = dataInputStream.readInt();
        this.format = new Path(dataInputStream.readUTF());
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            int n2;
            PlaceholderKey placeholderKey = new PlaceholderKey(dataInputStream);
            if ((placeholderKey = placeholderKey.shrink(placeholderStrategy)) != null) {
                this.add(placeholderKey);
                Map<String, Object> map = this.data.get(placeholderKey);
                n2 = dataInputStream.readInt();
                for (int j = 0; j < n2; ++j) {
                    String string = dataInputStream.readUTF();
                    Object object = this.read(dataInputStream, placeholderStrategy);
                    map.put(string, object);
                }
                continue;
            }
            int n3 = dataInputStream.readInt();
            for (n2 = 0; n2 < n3; ++n2) {
                dataInputStream.readUTF();
                this.read(dataInputStream, placeholderStrategy);
            }
        }
    }

    public PlaceholderMap(XElement xElement, PlaceholderStrategy placeholderStrategy) {
        this.setPlaceholderStrategy(placeholderStrategy);
        XElement xElement2 = xElement.getElement("version");
        if (xElement2 == null) {
            throw new XException("missing element 'version'");
        }
        this.version = xElement2.getInt();
        XElement xElement3 = xElement.getElement("format");
        if (xElement3 == null) {
            throw new XException("missing element 'format'");
        }
        this.format = new Path(xElement3.getString());
        int n = xElement.getElementCount();
        for (int i = 0; i < n; ++i) {
            XElement xElement4 = xElement.getElement(i);
            if (!xElement4.getName().equals("entry")) continue;
            PlaceholderKey placeholderKey = new PlaceholderKey(xElement4.getElement("key"));
            if ((placeholderKey = placeholderKey.shrink(placeholderStrategy)) == null) continue;
            this.add(placeholderKey);
            Map<String, Object> map = this.data.get(placeholderKey);
            int n2 = xElement4.getElementCount();
            for (int j = 0; j < n2; ++j) {
                XElement xElement5 = xElement4.getElement(j);
                if (!xElement5.getName().equals("item")) continue;
                String string = xElement5.getString("key");
                Object object = this.read(xElement5, placeholderStrategy);
                map.put(string, object);
            }
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_8);
        dataOutputStream.writeInt(this.version);
        dataOutputStream.writeUTF(this.format.toString());
        dataOutputStream.writeInt(this.data.size());
        for (Map.Entry<Key, Map<String, Object>> entry : this.data.entrySet()) {
            ((PlaceholderKey)entry.getKey()).write(dataOutputStream);
            Map<String, Object> map = entry.getValue();
            dataOutputStream.writeInt(map.size());
            for (Map.Entry<String, Object> entry2 : map.entrySet()) {
                dataOutputStream.writeUTF(entry2.getKey());
                this.write(entry2.getValue(), dataOutputStream);
            }
        }
    }

    private void write(Object object, DataOutputStream dataOutputStream) throws IOException {
        if (object instanceof String) {
            dataOutputStream.writeByte(0);
            dataOutputStream.writeUTF((String)object);
        } else if (object instanceof Integer) {
            dataOutputStream.writeByte(1);
            dataOutputStream.writeInt((Integer)object);
        } else if (object instanceof Long) {
            dataOutputStream.writeByte(2);
            dataOutputStream.writeLong((Long)object);
        } else if (object instanceof Double) {
            dataOutputStream.writeByte(3);
            dataOutputStream.writeDouble((Double)object);
        } else if (object instanceof Boolean) {
            dataOutputStream.writeByte(4);
            dataOutputStream.writeBoolean((Boolean)object);
        } else if (object instanceof PlaceholderMap) {
            dataOutputStream.writeByte(5);
            ((PlaceholderMap)object).write(dataOutputStream);
        } else if (object instanceof Object[]) {
            dataOutputStream.writeByte(6);
            Object[] objectArray = (Object[])object;
            dataOutputStream.writeInt(objectArray.length);
            for (Object object2 : objectArray) {
                this.write(object2, dataOutputStream);
            }
        } else {
            throw new IOException("unknown type: " + object.getClass());
        }
    }

    private Object read(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
        byte by = dataInputStream.readByte();
        switch (by) {
            case 0: {
                return dataInputStream.readUTF();
            }
            case 1: {
                return dataInputStream.readInt();
            }
            case 2: {
                return dataInputStream.readLong();
            }
            case 3: {
                return dataInputStream.readDouble();
            }
            case 4: {
                return dataInputStream.readBoolean();
            }
            case 5: {
                return new PlaceholderMap(dataInputStream, placeholderStrategy);
            }
            case 6: {
                int n = dataInputStream.readInt();
                Object[] objectArray = new Object[n];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = this.read(dataInputStream, placeholderStrategy);
                }
                return objectArray;
            }
        }
        throw new IOException("illegal format");
    }

    public void write(XElement xElement) {
        xElement.addElement("version").setInt(this.version);
        xElement.addElement("format").setString(this.format.toString());
        for (Map.Entry<Key, Map<String, Object>> entry : this.data.entrySet()) {
            XElement xElement2 = xElement.addElement("entry");
            ((PlaceholderKey)entry.getKey()).write(xElement2.addElement("key"));
            Map<String, Object> map = entry.getValue();
            for (Map.Entry<String, Object> entry2 : map.entrySet()) {
                XElement xElement3 = xElement2.addElement("item");
                xElement3.addString("key", entry2.getKey());
                this.write(entry2.getValue(), xElement3);
            }
        }
    }

    private void write(Object object, XElement xElement) {
        if (object instanceof String) {
            xElement.addString("type", "s");
            xElement.setString((String)object);
        } else if (object instanceof Integer) {
            xElement.addString("type", "i");
            xElement.setInt((Integer)object);
        } else if (object instanceof Long) {
            xElement.addString("type", "l");
            xElement.setLong((Long)object);
        } else if (object instanceof Double) {
            xElement.addString("type", "d");
            xElement.setDouble((Double)object);
        } else if (object instanceof Boolean) {
            xElement.addString("type", "b");
            xElement.setBoolean((Boolean)object);
        } else if (object instanceof PlaceholderMap) {
            xElement.addString("type", "p");
            ((PlaceholderMap)object).write(xElement);
        } else if (object instanceof Object[]) {
            Object[] objectArray;
            xElement.addString("type", "a");
            for (Object object2 : objectArray = (Object[])object) {
                this.write(object2, xElement.addElement("item"));
            }
        } else {
            throw new XException("unknown type: " + object.getClass());
        }
    }

    private Object read(XElement xElement, PlaceholderStrategy placeholderStrategy) {
        String string = xElement.getString("type");
        if ("s".equals(string)) {
            return xElement.getString();
        }
        if ("i".equals(string)) {
            return xElement.getInt();
        }
        if ("l".equals(string)) {
            return xElement.getLong();
        }
        if ("d".equals(string)) {
            return xElement.getDouble();
        }
        if ("b".equals(string)) {
            return xElement.getBoolean();
        }
        if ("p".equals(string)) {
            return new PlaceholderMap(xElement, placeholderStrategy);
        }
        if ("a".equals(string)) {
            XElement[] xElementArray = xElement.getElements("item");
            Object[] objectArray = new Object[xElementArray.length];
            for (int i = 0; i < xElementArray.length; ++i) {
                objectArray[i] = this.read(xElementArray[i], placeholderStrategy);
            }
            return objectArray;
        }
        throw new XException("unknown type: " + string);
    }

    public PlaceholderMap copy() {
        PlaceholderMap placeholderMap = new PlaceholderMap(this.format, this.version);
        for (Map.Entry<Key, Map<String, Object>> entry : this.data.entrySet()) {
            Key key = placeholderMap.copyKey(entry.getKey());
            placeholderMap.add(key);
            Map<String, Object> map = placeholderMap.data.get(key);
            for (Map.Entry<String, Object> entry2 : entry.getValue().entrySet()) {
                map.put(entry2.getKey(), this.copy(entry2.getValue()));
            }
        }
        return placeholderMap;
    }

    private Object copy(Object object) {
        if (object instanceof String) {
            return object;
        }
        if (object instanceof Integer) {
            return object;
        }
        if (object instanceof Long) {
            return object;
        }
        if (object instanceof Double) {
            return object;
        }
        if (object instanceof Boolean) {
            return object;
        }
        if (object instanceof PlaceholderMap) {
            return ((PlaceholderMap)object).copy();
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                objectArray2[i] = this.copy(objectArray[i]);
            }
            return objectArray2;
        }
        throw new IllegalArgumentException("unknown type: " + object.getClass());
    }

    public Key newKey(Path ... pathArray) {
        return new PlaceholderKey(pathArray, true);
    }

    public Key newUniqueKey(Path ... pathArray) {
        return new PlaceholderKey(pathArray, false);
    }

    public Key copyKey(Key key) {
        return new PlaceholderKey(key.getPlaceholders(), key.isShared());
    }

    public void setPlaceholderStrategy(PlaceholderStrategy placeholderStrategy) {
        if (this.strategy != null) {
            this.strategy.removeListener(this.listener);
        }
        this.strategy = placeholderStrategy;
        for (Map<String, Object> map : this.data.values()) {
            for (Object object : map.values()) {
                this.setPlaceholderStrategy(object, placeholderStrategy);
            }
        }
        if (this.strategy != null) {
            this.validate(this.strategy, false);
            this.strategy.addListener(this.listener);
        }
    }

    private void setPlaceholderStrategy(Object object, PlaceholderStrategy placeholderStrategy) {
        if (object instanceof PlaceholderMap) {
            ((PlaceholderMap)object).setPlaceholderStrategy(placeholderStrategy);
        } else if (object instanceof Object[]) {
            for (Object object2 : (Object[])object) {
                this.setPlaceholderStrategy(object2, placeholderStrategy);
            }
        }
    }

    public PlaceholderStrategy getPlaceholderStrategy() {
        return this.strategy;
    }

    public void validate(PlaceholderStrategy placeholderStrategy, boolean bl) {
        Key[] keyArray;
        if (placeholderStrategy == null) {
            return;
        }
        if (bl) {
            keyArray = this.data.values().iterator();
            while (keyArray.hasNext()) {
                Key[] keyArray2 = keyArray.next();
                for (Object v : keyArray2.values()) {
                    this.validate(v, placeholderStrategy);
                }
            }
        }
        for (Key key : keyArray = this.data.keySet().toArray(new Key[this.data.size()])) {
            PlaceholderKey placeholderKey = ((PlaceholderKey)key).shrink(placeholderStrategy);
            if (placeholderKey == key) continue;
            Map<String, Object> map = this.data.remove(key);
            if (placeholderKey == null) continue;
            this.data.put(placeholderKey, map);
        }
    }

    private void validate(Object object, PlaceholderStrategy placeholderStrategy) {
        if (object instanceof PlaceholderMap) {
            ((PlaceholderMap)object).validate(placeholderStrategy, true);
        } else if (object instanceof Object[]) {
            for (Object object2 : (Object[])object) {
                this.validate(object2, placeholderStrategy);
            }
        }
    }

    public void removeAll(Path path, boolean bl) {
        HashSet<Path> hashSet = new HashSet<Path>();
        hashSet.add(path);
        this.removeAll(hashSet, bl);
    }

    public void removeAll(Set<Path> set, boolean bl) {
        Key[] keyArray;
        if (set.isEmpty()) {
            return;
        }
        if (bl) {
            keyArray = this.data.values().iterator();
            while (keyArray.hasNext()) {
                Key[] keyArray2 = keyArray.next();
                for (Object v : keyArray2.values()) {
                    this.removeAll(v, set);
                }
            }
        }
        for (Key key : keyArray = this.data.keySet().toArray(new Key[this.data.size()])) {
            PlaceholderKey placeholderKey = ((PlaceholderKey)key).shrink(set);
            if (placeholderKey == key) continue;
            Map<String, Object> map = this.data.remove(key);
            if (placeholderKey == null) continue;
            this.data.put(placeholderKey, map);
        }
    }

    private void removeAll(Object object, Set<Path> set) {
        if (object instanceof PlaceholderMap) {
            ((PlaceholderMap)object).removeAll(set, true);
        } else if (object instanceof Object[]) {
            for (Object object2 : (Object[])object) {
                this.removeAll(object2, set);
            }
        }
    }

    public int getVersion() {
        return this.version;
    }

    public Path getFormat() {
        return this.format;
    }

    public void add(Key key) {
        if (key == null) {
            throw new IllegalArgumentException("placeholder must not be null");
        }
        Map<String, Object> map = this.data.get(key);
        if (map == null) {
            map = new LinkedHashMap<String, Object>();
            this.data.put(key, map);
        }
    }

    public void remove(Key key) {
        this.data.remove(key);
    }

    public Key[] getPlaceholders() {
        Set<Key> set = this.data.keySet();
        return set.toArray(new Key[set.size()]);
    }

    public String[] getKeys(Key key) {
        Map<String, Object> map = this.data.get(key);
        if (map == null) {
            return null;
        }
        Set<String> set = map.keySet();
        return set.toArray(new String[set.size()]);
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public void putString(Key key, String string, String string2) {
        this.put(key, string, string2);
    }

    public void putInt(Key key, String string, int n) {
        this.put(key, string, n);
    }

    public void putLong(Key key, String string, long l) {
        this.put(key, string, l);
    }

    public void putBoolean(Key key, String string, boolean bl) {
        this.put(key, string, bl);
    }

    public void putDouble(Key key, String string, double d) {
        this.put(key, string, d);
    }

    public void putMap(Key key, String string, PlaceholderMap placeholderMap) {
        this.put(key, string, placeholderMap);
    }

    public void putArray(Key key, String string, Object[] objectArray) {
        this.put(key, string, objectArray);
    }

    public void put(Key key, String string, Object object) {
        Class<?> clazz = this.invalidType(object);
        if (clazz != null) {
            throw new IllegalArgumentException("value of illegal type: " + (clazz instanceof String ? clazz : clazz.getClass()));
        }
        this.add(key);
        this.data.get(key).put(string, object);
    }

    private Object invalidType(Object object) {
        if (object instanceof String || object instanceof Integer || object instanceof Long || object instanceof Double || object instanceof Boolean || object instanceof PlaceholderMap) {
            return null;
        }
        if (object instanceof Object[]) {
            for (Object object2 : (Object[])object) {
                Object object3 = this.invalidType(object2);
                if (object3 == null) continue;
                return object3;
            }
        }
        if (object == null) {
            return "null";
        }
        return null;
    }

    public Object remove(Key key, String string) {
        Map<String, Object> map = this.data.get(key);
        if (map == null) {
            return null;
        }
        return map.remove(string);
    }

    public boolean contains(Key key, String string) {
        return this.get(key, string) != null;
    }

    public String getString(Key key, String string) {
        Object object = this.get(key, string);
        if (object instanceof String) {
            return (String)object;
        }
        throw new IllegalArgumentException();
    }

    public int getInt(Key key, String string) {
        Object object = this.get(key, string);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        throw new IllegalArgumentException();
    }

    public long getLong(Key key, String string) {
        Object object = this.get(key, string);
        if (object instanceof Long) {
            return (Long)object;
        }
        throw new IllegalArgumentException();
    }

    public boolean getBoolean(Key key, String string) {
        Object object = this.get(key, string);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new IllegalArgumentException();
    }

    public double getDouble(Key key, String string) {
        Object object = this.get(key, string);
        if (object instanceof Double) {
            return (Double)object;
        }
        throw new IllegalArgumentException();
    }

    public PlaceholderMap getMap(Key key, String string) {
        Object object = this.get(key, string);
        if (object instanceof PlaceholderMap) {
            return (PlaceholderMap)object;
        }
        throw new IllegalArgumentException();
    }

    public Object[] getArray(Key key, String string) {
        Object object = this.get(key, string);
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        throw new IllegalArgumentException();
    }

    public Object get(Key key, String string) {
        Map<String, Object> map = this.data.get(key);
        if (map == null) {
            return null;
        }
        return map.get(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PlaceholderKey
    implements Key {
        private Path[] placeholders;
        private boolean shared;

        public PlaceholderKey(Path[] pathArray, boolean bl) {
            if (pathArray == null) {
                throw new IllegalArgumentException("placeholders must not be null");
            }
            this.placeholders = pathArray;
            this.shared = bl;
        }

        public PlaceholderKey(DataInputStream dataInputStream) throws IOException {
            this.shared = dataInputStream.readBoolean();
            this.placeholders = new Path[dataInputStream.readInt()];
            for (int i = 0; i < this.placeholders.length; ++i) {
                this.placeholders[i] = new Path(dataInputStream.readUTF());
            }
        }

        public PlaceholderKey(XElement xElement) {
            this.shared = xElement.getBoolean("shared");
            XElement[] xElementArray = xElement.getElements("placeholder");
            this.placeholders = new Path[xElementArray.length];
            for (int i = 0; i < xElementArray.length; ++i) {
                this.placeholders[i] = new Path(xElementArray[i].getString());
            }
        }

        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeBoolean(this.shared);
            dataOutputStream.writeInt(this.placeholders.length);
            for (Path path : this.placeholders) {
                dataOutputStream.writeUTF(path.toString());
            }
        }

        public void write(XElement xElement) {
            xElement.addBoolean("shared", this.shared);
            for (Path path : this.placeholders) {
                xElement.addElement("placeholder").setString(path.toString());
            }
        }

        public PlaceholderKey shrink(PlaceholderStrategy placeholderStrategy) {
            if (placeholderStrategy == null) {
                return this;
            }
            boolean[] blArray = new boolean[this.placeholders.length];
            int n = 0;
            for (int i = 0; i < blArray.length; ++i) {
                blArray[i] = placeholderStrategy.isValidPlaceholder(this.placeholders[i]);
                if (!blArray[i]) continue;
                ++n;
            }
            if (n == this.placeholders.length) {
                return this;
            }
            if (n == 0) {
                return null;
            }
            Path[] pathArray = new Path[blArray.length];
            int n2 = 0;
            for (int i = 0; i < pathArray.length; ++i) {
                if (!blArray[i]) continue;
                pathArray[n2++] = this.placeholders[i];
            }
            return new PlaceholderKey(pathArray, this.shared);
        }

        public PlaceholderKey shrink(Set<Path> set) {
            boolean[] blArray = new boolean[this.placeholders.length];
            int n = 0;
            for (int i = 0; i < blArray.length; ++i) {
                boolean bl = blArray[i] = !set.contains(this.placeholders[i]);
                if (!blArray[i]) continue;
                ++n;
            }
            if (n == this.placeholders.length) {
                return this;
            }
            if (n == 0) {
                return null;
            }
            Path[] pathArray = new Path[blArray.length];
            int n2 = 0;
            for (int i = 0; i < pathArray.length; ++i) {
                if (!blArray[i]) continue;
                pathArray[n2++] = this.placeholders[i];
            }
            return new PlaceholderKey(pathArray, this.shared);
        }

        @Override
        public Path[] getPlaceholders() {
            return this.placeholders;
        }

        @Override
        public boolean isShared() {
            return this.shared;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            for (Path path : this.placeholders) {
                stringBuilder.append(path);
                stringBuilder.append(", ");
            }
            stringBuilder.append("shared=");
            stringBuilder.append(this.shared);
            return stringBuilder.toString();
        }

        public int hashCode() {
            int n = Arrays.hashCode(this.placeholders);
            if (this.shared) {
                return n;
            }
            return -n;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!this.isShared()) {
                return false;
            }
            if (object.getClass() != this.getClass()) {
                return false;
            }
            PlaceholderKey placeholderKey = (PlaceholderKey)object;
            if (!placeholderKey.isShared()) {
                return false;
            }
            return Arrays.equals(this.placeholders, placeholderKey.placeholders);
        }
    }

    public static interface Key {
        public Path[] getPlaceholders();

        public boolean isShared();
    }
}

