/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.fife.io.UnicodeReader;
import org.fife.io.UnicodeWriter;
import org.fife.ui.rsyntaxtextarea.FileLocation;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

public class TextEditorPane
extends RSyntaxTextArea
implements DocumentListener {
    private static final long serialVersionUID = 1L;
    public static final String FULL_PATH_PROPERTY = "TextEditorPane.fileFullPath";
    public static final String DIRTY_PROPERTY = "TextEditorPane.dirty";
    public static final String READ_ONLY_PROPERTY = "TextEditorPane.readOnly";
    private FileLocation loc;
    private String charSet;
    private boolean readOnly;
    private boolean dirty;
    private long lastSaveOrLoadTime;
    public static final long LAST_MODIFIED_UNKNOWN = 0L;
    private static final String DEFAULT_FILE_NAME = "Untitled.txt";

    public TextEditorPane() {
        this(0);
    }

    public TextEditorPane(int n) {
        this(n, false);
    }

    public TextEditorPane(int n, boolean bl) {
        super(n);
        this.setLineWrap(bl);
        try {
            this.init(null, null);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public TextEditorPane(int n, boolean bl, FileLocation fileLocation) throws IOException {
        this(n, bl, fileLocation, null);
    }

    public TextEditorPane(int n, boolean bl, FileLocation fileLocation, String string) throws IOException {
        super(n);
        this.setLineWrap(bl);
        this.init(fileLocation, string);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private static final String getDefaultEncoding() {
        String string = System.getProperty("file.encoding");
        if (string == null) {
            try {
                File file = File.createTempFile("rsta", null);
                FileWriter fileWriter = new FileWriter(file);
                string = fileWriter.getEncoding();
                fileWriter.close();
                file.deleteOnExit();
            }
            catch (IOException iOException) {
                string = "US-ASCII";
            }
        }
        return string;
    }

    public String getEncoding() {
        return this.charSet;
    }

    public String getFileFullPath() {
        return this.loc.getFileFullPath();
    }

    public String getFileName() {
        return this.loc.getFileName();
    }

    public long getLastSaveOrLoadTime() {
        return this.lastSaveOrLoadTime;
    }

    public Object getLineSeparator() {
        return this.getDocument().getProperty("__EndOfLine__");
    }

    private void init(FileLocation fileLocation, String string) throws IOException {
        if (fileLocation == null) {
            this.loc = FileLocation.create(DEFAULT_FILE_NAME);
            this.charSet = string == null ? TextEditorPane.getDefaultEncoding() : string;
            this.setLineSeparator(System.getProperty("line.separator"));
        } else {
            this.load(fileLocation, string);
        }
        if (this.loc.isLocalAndExists()) {
            File file = new File(this.loc.getFileFullPath());
            this.lastSaveOrLoadTime = file.lastModified();
            this.setReadOnly(!file.canWrite());
        } else {
            this.lastSaveOrLoadTime = 0L;
            this.setReadOnly(false);
        }
        this.setDirty(false);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (!this.dirty) {
            this.setDirty(true);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isLocal() {
        return this.loc.isLocal();
    }

    public boolean isLocalAndExists() {
        return this.loc.isLocalAndExists();
    }

    public boolean isModifiedOutsideEditor() {
        return this.loc.getActualLastModified() > this.getLastSaveOrLoadTime();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(FileLocation fileLocation, String string) throws IOException {
        this.loc = fileLocation;
        if (fileLocation.isLocal() && !fileLocation.isLocalAndExists()) {
            this.charSet = string != null ? string : TextEditorPane.getDefaultEncoding();
            return;
        }
        UnicodeReader unicodeReader = new UnicodeReader(fileLocation.getInputStream(), string);
        this.charSet = unicodeReader.getEncoding();
        Document document = this.getDocument();
        document.removeDocumentListener(this);
        BufferedReader bufferedReader = new BufferedReader(unicodeReader);
        try {
            this.read(bufferedReader, null);
        }
        finally {
            document.addDocumentListener(this);
            bufferedReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() throws IOException {
        String string = this.getEncoding();
        UnicodeReader unicodeReader = new UnicodeReader(this.loc.getInputStream(), string);
        String string2 = unicodeReader.getEncoding();
        BufferedReader bufferedReader = new BufferedReader(unicodeReader);
        try {
            this.read(bufferedReader, null);
        }
        finally {
            bufferedReader.close();
        }
        this.setEncoding(string2);
        this.setDirty(false);
        this.syncLastSaveOrLoadTimeToActualFile();
        this.discardAllEdits();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (!this.dirty) {
            this.setDirty(true);
        }
    }

    public void save() throws IOException {
        this.saveImpl(this.loc);
        this.setDirty(false);
        this.syncLastSaveOrLoadTimeToActualFile();
    }

    public void saveAs(FileLocation fileLocation) throws IOException {
        this.saveImpl(fileLocation);
        String string = this.getFileFullPath();
        this.loc = fileLocation;
        this.setDirty(false);
        this.lastSaveOrLoadTime = fileLocation.getActualLastModified();
        this.firePropertyChange(FULL_PATH_PROPERTY, string, this.getFileFullPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveImpl(FileLocation fileLocation) throws IOException {
        OutputStream outputStream = fileLocation.getOutputStream();
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new UnicodeWriter(outputStream, this.getEncoding())));
        try {
            this.write(printWriter);
        }
        finally {
            printWriter.close();
        }
    }

    private void setDirty(boolean bl) {
        if (this.dirty != bl) {
            this.dirty = bl;
            this.firePropertyChange(DIRTY_PROPERTY, !bl, bl);
        }
    }

    public void setDocument(Document document) {
        Document document2 = this.getDocument();
        if (document2 != null) {
            document2.removeDocumentListener(this);
        }
        super.setDocument(document);
        document.addDocumentListener(this);
    }

    public void setEncoding(String string) {
        if (string == null) {
            throw new NullPointerException("encoding cannot be null");
        }
        if (!Charset.isSupported(string)) {
            throw new UnsupportedCharsetException(string);
        }
        if (this.charSet == null || !this.charSet.equals(string)) {
            this.charSet = string;
            this.setDirty(true);
        }
    }

    public void setLineSeparator(String string) {
        this.setLineSeparator(string, true);
    }

    public void setLineSeparator(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("terminator cannot be null");
        }
        if (!("\r\n".equals(string) || "\n".equals(string) || "\r".equals(string))) {
            throw new IllegalArgumentException("Invalid line terminator");
        }
        Document document = this.getDocument();
        Object object = document.getProperty("__EndOfLine__");
        if (!string.equals(object)) {
            document.putProperty("__EndOfLine__", string);
            if (bl) {
                this.setDirty(true);
            }
        }
    }

    public void setReadOnly(boolean bl) {
        if (this.readOnly != bl) {
            this.readOnly = bl;
            this.firePropertyChange(READ_ONLY_PROPERTY, !bl, bl);
        }
    }

    public void syncLastSaveOrLoadTimeToActualFile() {
        if (this.loc.isLocalAndExists()) {
            this.lastSaveOrLoadTime = this.loc.getActualLastModified();
        }
    }
}

