% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spell-check.R
\name{spell_check_package}
\alias{spell_check_package}
\alias{spelling}
\alias{spell_check_setup}
\alias{spell_check_test}
\title{Package Spell Checking}
\usage{
spell_check_package(pkg = ".", vignettes = TRUE, lang = "en_GB",
  use_wordlist = TRUE)

spell_check_setup(pkg = ".", vignettes = TRUE, lang = "en_GB",
  error = FALSE)
}
\arguments{
\item{pkg}{path to package root directory containing the \code{DESCRIPTION} file}

\item{vignettes}{also check all \code{rmd} and \code{rnw} files in the pkg \code{vignettes} folder}

\item{lang}{dictionary string for \link[hunspell:dictionary]{hunspell},
usually either \code{"en_US"} or \code{"en_GB"}.}

\item{use_wordlist}{ignore words in the package \link[=get_wordlist]{WORDLIST} file}

\item{error}{make \code{R CMD check} fail when spelling errors are found.
Default behaviour only prints spelling errors to the console at the end of \code{CMD check}.}
}
\description{
Automatically spell-check package description, documentation, and vignettes.
}
\details{
Parse and spell check R package manual pages, rmd/rnw vignettes, and text fields in the
\code{DESCRIPTION} file. Use the \link[=get_wordlist]{WORDLIST} file to allow custom words in your
package, which will be added to the dictionary when spell checking.

The \link{spell_check_setup} function adds a unit test to your package which automatically
runs a spell check on documentation and vignettes during \code{R CMD check}. By default this
unit test never fails; it merely prints potential spelling errors to the console.

Hunspell includes dictionaries for \code{en_US} and \code{en_GB} by default. Other languages
require installation of a custom dictionary, see \link[hunspell:hunspell]{hunspell} for details.
}
\seealso{
Other spelling: \code{\link{spell_check_files}},
  \code{\link{wordlist}}
}
