% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sperrorest_resampling.R
\name{represampling.factor.bootstrap}
\alias{represampling.factor.bootstrap}
\title{Bootstrap at an aggregated level}
\usage{
represampling.factor.bootstrap(data, fac, repetition = 1, nboot = -1,
  seed1 = NULL, oob = FALSE)
}
\arguments{
\item{data}{\code{data.frame} containing at least the columns specified
by \code{coords}}

\item{fac}{defines a grouping or partitioning of the samples in \code{data};
three possible types:
(1) the name of a variable in \code{data} (coerced to factor if not already
a factor variable);
(2) a factor variable (or a vector that can be coerced to factor);
(3) a list of factor variables (or vectors that can be coerced to factor);
this list must be of length \code{length(repetition)}, and if it is named,
the names must be equal to \code{as.character(repetition)}; this list will
typically be generated by a \code{partition.*} function with
\code{return.factor = TRUE} (see Examples below)}

\item{repetition}{numeric vector: cross-validation repetitions
to be generated. Note that this is not the number of repetitions,
but the indices of these repetitions. E.g., use \code{repetition = c(1:100)}
to obtain (the 'first') 100 repetitions, and \code{repetition = c(101:200)}
to obtain a different set of 100 repetitions.}

\item{nboot}{number of bootstrap replications used for generating the
bootstrap training sample (\code{nboot[1]}) and the test sample
(\code{nboot[2]}); \code{nboot[2]} is ignored (with a warning) if
\code{oob = TRUE}. A value of \code{-1} will be substituted with the number
of levels of the factor variable, corresponding to an \emph{n} out of
\emph{n} bootstrap at the grouping level defined by \code{fac}.}

\item{seed1}{\code{seed1+i} is the random seed that will be used by
\code{\link[=set.seed]{set.seed()}} in repetition \code{i} (\code{i} in \code{repetition})
to initialize the random number generator before sampling from the data set.}

\item{oob}{if \code{TRUE}, the test sample will be the out-of-bag sample;
if \code{FALSE} (default), the test sample is an independently drawn
bootstrap sample of size \code{nboot[2]}.}
}
\description{
\code{represampling.factor.bootstrap} resamples partitions defined by a
factor variable. This can be used for non-overlapping block bootstraps and
similar.
}
\details{
\code{nboot} refers to the number of groups
(as defined by the factors) to be drawn with replacement from the set of
groups. I.e., if \code{fac} is a factor variable, \code{nboot} would normally
not be greater than \code{nlevels(fac)}, \code{nlevels(fac)} being the
default as per \code{nboot = -1}.
}
\examples{
data(ecuador)
# a dummy example for demonstration, performing bootstrap 
# at the level of an arbitrary factor variable:
parti <- represampling.factor.bootstrap(ecuador, 
                                       factor(floor(ecuador$dem / 100)), 
                                       oob = TRUE)
# plot(parti,ecuador)
# using the factor bootstrap for a non-overlapping block bootstrap
# (see also represampling.tile.bootstrap):
fac <- partition.tiles(ecuador, return.factor = TRUE, repetition = c(1:3), 
                       dsplit = 500, min.n = 200, rotation = 'random', offset = 'random')
parti <- represampling.factor.bootstrap(ecuador, fac, oob = TRUE, repetition = c(1:3))
# plot(parti, ecuador)

}
\seealso{
\code{\link[=represampling.disc.bootstrap]{represampling.disc.bootstrap()}},
\code{\link[=represampling.tile.bootstrap]{represampling.tile.bootstrap()}}
}
