% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spftir.R
\name{spvalley}
\alias{spvalley}
\title{Identification of Valleys of a Mid-infrared Spectra}
\usage{
spvalley(spectra, span = 3, tol = 0.2)
}
\arguments{
\item{spectra}{matrix. The matrix of FTIR spectra. The first row corresponds to wavenumber; the remaining rows corresponds to absorbances.}

\item{span}{numeric. Peak detection threshold.}

\item{tol}{numeric. Percentage of the maximum value of the spectrum (positive value).}
}
\value{
An object of class spvalley, which is a list of matrices for each of the spectra.
}
\description{
This function allows to identify valleys of a mid-infrared spectra.
}
\examples{
data(spData)
# Convert data frame to matrix
spectra <- as.matrix(t(spData))
# List of valley detection
vls <- sppeak(spectra=spectra, span=3, tol=0.2)
# Valleys of the first spectrum
vls[[1]]
# Valleys of the second spectrum
vls[[2]]
}
\author{
Claudio Pozo Valenzuela [aut, cre] and Saddys Rodriguez-llamazares [aut]
}

