% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{r_unif}
\alias{r_unif}
\alias{r_unif_cir}
\alias{r_unif_sph}
\title{Sample uniformly distributed circular and spherical data}
\usage{
r_unif_cir(n, M = 1L, sorted = FALSE)

r_unif_sph(n, p, M = 1L)
}
\arguments{
\item{n}{sample size.}

\item{M}{number of samples of size \code{n}. Defaults to \code{1}.}

\item{sorted}{return each circular sample sorted? Defaults to \code{FALSE}.}

\item{p}{integer giving the dimension of the ambient space \eqn{R^p} that
contains \eqn{S^{p-1}}.}
}
\value{
\itemize{
  \item \code{r_unif_cir}: a \bold{matrix} of size \code{c(n, M)} with
  \code{M} random samples of size \code{n} of uniformly-generated circular
  data on \eqn{[0, 2\pi)}.
  \item \code{r_unif_sph}: an \bold{array} of size \code{c(n, p, M)} with
  \code{M} random samples of size \code{n} of uniformly-generated
  directions on \eqn{S^{p-1}}.
}
}
\description{
Simulation of the uniform distribution on \eqn{[0, 2\pi)} and
\eqn{S^{p-1}:=\{{\bf x}\in R^p:||{\bf x}||=1\}}{
S^{p-1}:=\{x\in R^p:||x||=1\}}, \eqn{p\ge 2}.
}
\examples{
# A sample on [0, 2*pi)
n <- 5
r_unif_cir(n = n)

# A sample on S^1
p <- 2
samp <- r_unif_sph(n = n, p = p)
samp
rowSums(samp^2)

# A sample on S^2
p <- 3
samp <- r_unif_sph(n = n, p = p)
samp
rowSums(samp^2)
}
