% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rosenberg.R
\name{rosenberg}
\alias{rosenberg}
\title{Rosenberg's probability of reciprocal monophyly}
\usage{
rosenberg(phy)
}
\arguments{
\item{phy}{A tree of class `phylo'.}
}
\value{
A numeric vector with names giving the node numbers of \code{phy}.
}
\description{
This function computes Rosenberg's probability of reciprocal monophyly for
each dichotomous node of a phylogenetic tree.
}
\details{
Because \code{ape} plots node labels in a different manner to the method in
which they are stored, when plotting the node labels made by
\code{rosenberg}, make sure the \code{node} argument is given as shown in
the examples below.
}
\examples{

data(anoteropsis)
anoTr <- ape::nj(ape::dist.dna(anoteropsis))
anoLab <- rosenberg(anoTr)
ape::plot.phylo(anoTr)
ape::nodelabels(round(anoLab,3), node=as.numeric(names(anoLab)))

data(dolomedes)
doloTr <- ape::nj(ape::dist.dna(dolomedes))
doloRose <- rosenberg(doloTr)
ape::plot.phylo(doloTr)
ape::nodelabels(round(doloRose, 3))

#Colour circles for nodes with a probability < 0.005
doloNodes <- doloRose < 0.005
doloLabs <- doloRose
doloLabs[doloNodes] <- "blue"
doloLabs[!doloNodes] <- "red"
ape::plot.phylo(doloTr, cex=0.7)
ape::nodelabels(pch=21, bg=doloLabs, node=as.numeric(names(doloLabs)), cex=2)
graphics::legend(x=0.015, y=16.13, legend=c("significant", "not significant"), pch=21, 
    pt.bg=c("blue", "red"), bty="n", pt.cex=2)

}
\references{
Rosenberg, N. A. (2007). Statistical tests for taxonomic
distinctiveness from observations of monophyly. _Evolution_ *61* (2),
317-323.
}
\seealso{
\code{\link{nodelabels}}.
}
\author{
Samuel Brown <s_d_j_brown@hotmail.com>
}
\keyword{Sampling}
