% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manual_tour.r
\name{create_manip_space}
\alias{create_manip_space}
\title{Create a manipulation space}
\usage{
create_manip_space(basis, manip_var)
}
\arguments{
\item{basis}{A (p, d) orthonormal matrix.}

\item{manip_var}{Number of the column/dimension to rotate.}
}
\value{
A (p, d+1) orthonormal matrix, the manipulation space.
}
\description{
Typically called by \code{manual_tour()}. Creates a (p, d) orthonormal matrix,
the manipulation space from the given basis right concatenated with a zero
vector, with manip_var set to 1.
}
\examples{
flea_std <- tourr::rescale(tourr::flea[,1:6])

rb <- basis_random(n = ncol(flea_std))
create_manip_space(basis = rb, manip_var = 4)
}
