% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_render.r
\name{render_plotly}
\alias{render_plotly}
\title{Animation the frames as a HTML widget.}
\usage{
render_plotly(
  fps = 8L,
  tooltip = "none",
  html_filename = NULL,
  save_widget_args = list(),
  ...
)
}
\arguments{
\item{fps}{Frames animated per second. Defaults to 8.}

\item{tooltip}{Character vector of aesthetic mappings to show in the
hover-over tooltip (passed to \code{plotly::ggplot()}).
Defaults to "none". "all" shows all the aesthetic mappings.
The order of text controls the order they appear.
For example, tooltip = c("id", "frame", "x", "y", "category", "color").}

\item{html_filename}{Optional, saves the plotly object as an HTML widget to
this string (without the directory path).
Defaults to NULL (not saved). For more output control use \code{save_widget_args}
or call \code{htmlwidgets::saveWidget()} on a return object of \code{render_plotly()}.}

\item{save_widget_args}{A list of arguments to be called in
\code{htmlwidgets::saveWidget()} when used with a \code{html_filename}.}

\item{...}{Passes arguments to \code{render_(...)}.}
}
\description{
Takes the result of \code{array2df()} and animations them via \code{{plotly}}
into a  self-contained HTML widget.
}
\seealso{
\code{\link{render_}} for \code{...} arguments.

\code{\link[plotly]{ggplotly}} for source documentation of \code{tooltip}.

\code{\link[htmlwidgets]{saveWidget}} for more control of .gif output.
}
