% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_ggproto_visualize.r
\name{filmstrip}
\alias{filmstrip}
\title{Create a "filmstrip" of the frames of a ggtour.}
\usage{
filmstrip(ggtour)
}
\arguments{
\item{ggtour}{A grammar of graphics tour with appended protos added.
A return from \verb{ggtour() + proto_*()}.}
}
\description{
Appends \code{facet_wrap(vars(frame_number))} & minor themes to the ggtour. If the
number of frames is more than desired, try increasing the \code{angle} argument on
the tour.
}
\examples{
dat <- scale_sd(tourr::flea[, 1:6])
clas <- tourr::flea$species
bas <- basis_pca(dat)
mv <- manip_var_of(bas)

## d = 2 case
mt_path <- manual_tour(bas, manip_var = mv)
ggt <- ggtour(mt_path, dat, angle = .25) +
  proto_basis() +
  proto_point(list(color = clas, shape = clas),
              list(size = 1.5))
filmstrip(ggt)

## d = 1 case
bas1d <- basis_pca(dat, d = 1)
mt_path1d <- manual_tour(basis = bas1d, manip_var = mv)
ggt1d <- ggtour(mt_path1d, dat, angle = .3) +
  proto_default1d(list(fill = clas))

ggt1d <- ggtour(mt_path1d, dat) +
  proto_default1d(list(fill = clas))
\dontrun{
filmstrip(ggt1d)}
}
\seealso{
Other ggtour proto: 
\code{\link{ggtour}()},
\code{\link{proto_basis}()},
\code{\link{proto_default}()},
\code{\link{proto_density}()},
\code{\link{proto_hex}()},
\code{\link{proto_highlight}()},
\code{\link{proto_origin}()},
\code{\link{proto_point}()},
\code{\link{proto_text}()}
}
\concept{ggtour proto}
