% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zDepricated_2_render.r
\name{render_gganimate}
\alias{render_gganimate}
\title{Render the frames as a \emph{gganimate} animation.}
\usage{
render_gganimate(
  fps = 8,
  rewind = FALSE,
  start_pause = 0.5,
  end_pause = 1,
  gif_filename = NULL,
  gif_path = NULL,
  gganimate_args = list(),
  ...
)
}
\arguments{
\item{fps}{Frames animated per second. Defaults to 8.}

\item{rewind}{Logical, should the animation play backwards after reaching
the end? Default to FALSE.}

\item{start_pause}{Number of seconds to pause on the first frame for.
Defaults to .5.}

\item{end_pause}{Number of seconds to pause on the last frame for.
Defaults to 1.}

\item{gif_filename}{Optional, saves the animation as a GIF to this string
(without the directory path). Defaults to NULL (no GIF saved).
For more output control, call \code{gganimate::anim_save()} on a return object of
\code{render_gganimate()}.}

\item{gif_path}{Optional, A string of the directory path (without the
filename) to save a GIF to. Defaults to NULL (current work directory).}

\item{gganimate_args}{A list of arguments assigned to a vector passe outside
of an aes() call. Anything that would be put in \code{geom_point(aes(), X)}.
Typically a single numeric for point size, alpha, or similar
For example, \code{geom_point(aes(), size = 2, alpha = .7)} becomes
\code{identity_args = list(size = 2, alpha = .7)}.}

\item{...}{Passes arguments to \code{render_(...)}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}, see \code{\link{ggtour}}.
Takes the result of \code{array2df()} and renders them into a
\emph{gganimate} animation.
}
\examples{
library(spinifex)
message("It's suggested to switch to the proto api, see `?ggtour` to get started.")

## Setup
dat_std  <- scale_sd(wine[, 2:6])
clas     <- wine$Type
bas      <- basis_pca(dat_std)
mv       <- manip_var_of(bas)
mt       <- manual_tour(basis = bas, manip_var = mv)
mt_df_ls <- array2df(basis_array = mt, data = dat_std)

\donttest{
render_gganimate(frames = mt_df_ls)

require("ggplot2")
render_gganimate(
  frames = mt_df_ls, axes = "bottomleft",
  fps = 10, rewind = TRUE, start_pause = 1, end_pause = 1.5,
  aes_args = list(color = clas, shape = clas),
  identity_args = list(size = 2, alpha = .7),
  ggproto = list(theme_void(),
                 ggtitle("My title"),
                 scale_color_brewer(palette = "Set2")))

## Saving a .gif(may require additional setup)
if(FALSE) ## Don't run by mistake
  render_gganimate(frames = mt_df_ls, axes = "bottomleft",
                   gif_filename = "myRadialTour.gif", gif_path = "./output")}
}
\seealso{
\code{\link{render_}} for \code{...} arguments.

\code{\link[gganimate:anim_save]{gganimate::anim_save}} for more control of .gif output.
}
